% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotKM.R
\name{plotKM}
\alias{plotKM}
\title{Compare and Draw the KM curves of any given nodes}
\usage{
plotKM(
df,
treepoints,
mytree,
risk.table=TRUE
)
}
\arguments{
\item{df}{"data" in the returned result of the \code{survivalpath()} function}

\item{treepoints}{list object;Specify the node for drawing the KM curve, which is in the survival path tree}

\item{mytree}{"tree" in the returned result of the \code{survivalpath()} function}

\item{risk.table}{Logical value. Allowed values include:TRUE or FALSE specifying whether to show the risk table. Default is FALSE.}
}
\value{
No return value.
}
\description{
According to the survival path tree, draw the KM curves of the using any nodes on the survival tree
}
\details{
Plot survival curves for patients contained in nodes in the survival path tree.
}
\examples{
library(dplyr)
data("DTSDHCC")
id = DTSDHCC$ID[!duplicated(DTSDHCC$ID)]
set.seed(123)
id = sample(id,500)
miniDTSDHCC <- DTSDHCC[DTSDHCC$ID \%in\% id,]
dataset = timedivision(miniDTSDHCC,"ID","Date",period = 90,left_interval = 0.5,right_interval=0.5)
resu <- generatorDTSD(dataset,periodindex="time_slice",IDindex="ID" ,timeindex="OStime_day",
 statusindex="Status_of_death",variable =c( "Age", "Amount.of.Hepatic.Lesions",
 "Largest.Diameter.of.Hepatic.Lesions",
 "New.Lesion","Vascular.Invasion" ,"Local.Lymph.Node.Metastasis",
 "Distant.Metastasis" , "Child_pugh_score" ,"AFP"),predict.time=365*1)
result <- survivalpath(resu,time_slices =9)

mytree <- result$tree

library(ggplot2)
library(ggtree)
ggtree(mytree, color="black",linetype=1,size=1.2,ladderize = TRUE )+
 theme_tree2() +
 geom_text2(aes(label=label),hjust=0.6, vjust=-0.6 ,size=3.0)+
 geom_text2(aes(label=paste(node,size,mytree@data$survival,mytree@data$survivalrate,sep = "/")),
 hjust=0.6, vjust=-1.85 ,size=3.0)+
 #geom_point2(aes(shape=isTip, color=isTip), size=mytree1@data$os/40)+
 geom_point2(aes(shape=isTip, color=isTip), size=mytree@data$size\%/\%200+1,show.legend=FALSE)+
 #guides(color=guide_legend(title="node name/sample number/Median survival time/Survival rate")) +
 labs(size= "Nitrogen",
      x = "TimePoints",
      y = "Survival",
      subtitle = "node_name/sample number/Median survival time/Survival rate",
      title = "Survival Tree") +
 theme(legend.title=element_blank(),legend.position = c(0.1,0.9))

#plot KM curve
treepoints = c(14,20)
plotKM(result$data, treepoints,mytree,risk.table=T)

}
\seealso{
survminer
}
