% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_ellipsoid_from_vertices.R
\name{make_ellipsoid_from_vertices}
\alias{make_ellipsoid_from_vertices}
\title{Constructs a new d-dimensional ellipsoid with the given "positive vertices", and size parameter, c.  The constructed ellipsoid is centered at the origin.Note that the input vertices (i.e., the columns of V) must therefore be orthogonal vectors, themselves centered at the origin.The size parameter, c, may be needed because the points alone only determine the eigenvalues up to a positive constant. For vertices which fall on the constructed ellipsoid, choose as the size parameterc = 1.The new ellipsoid is centered at the origin.}
\usage{
make_ellipsoid_from_vertices(V, c)
}
\arguments{
\item{V}{A d x d array of positive vertices (in columns)}

\item{c}{The size parameter of the new ellipsoid}
}
\value{
A new ellipsoid, centered at the origin, with the given vertices
}
\description{
Constructs a new d-dimensional ellipsoid with the given "positive vertices", and size parameter, c.  The constructed ellipsoid is centered at the origin.Note that the input vertices (i.e., the columns of V) must therefore be orthogonal vectors, themselves centered at the origin.The size parameter, c, may be needed because the points alone only determine the eigenvalues up to a positive constant. For vertices which fall on the constructed ellipsoid, choose as the size parameterc = 1.The new ellipsoid is centered at the origin.
}
\examples{
hellip <- hyperellipsoid()
V <- vertices(hellip)
c <- 4
make_ellipsoid_from_vertices(V,c)
}
