% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmmModel_estimates.R
\name{lmmModel_estimates}
\alias{lmmModel_estimates}
\title{Get estimates from a linear mixed model of tumor growth data}
\usage{
lmmModel_estimates(model)
}
\arguments{
\item{model}{An object of class "lme" representing the linear mixed-effects model fitted by \code{\link[=lmmModel]{lmmModel()}}.}
}
\value{
A data frame with the estimated values for the coefficients of the tumor growth for each treatment,
the standard deviation of the random effects, and the standard deviation of the residuals of the model.
These values can be useful for the power analysis of the model using \code{\link[=APrioriPwr]{APrioriPwr()}}.
}
\description{
\code{lmmModel_estimates} allows the user to easily extract some of the interesting model estimates for further use in other functions,
such as for power calculation.
}
\details{
The model estimates provided by \code{lmmModel_estimates} include:
\itemize{
\item Fixed effect coefficients: \eqn{\hat{\beta}_C}, \eqn{\hat{\beta}_A}, \eqn{\hat{\beta}_B}, \eqn{\hat{\beta}_{AB}},
which represent the estimated specific growth rates for the Control, Drug A, Drug B and Combination groups, respectively.
These are shown in columns \code{control}, \code{drug_a}, \code{drug_b}, and \code{combination}, respectively.
\item Standard deviation of the random effects (between-subject variance). Column \code{sd_ranef}.
\item Standard deviation of the residuals (within-subject variance). Column \code{sd_resid}.
}
}
\examples{
data("grwth_data")
# Fit example model
lmm <- lmmModel(
  data = grwth_data,
  sample_id = "subject",
  time = "Time",
  treatment = "Treatment",
  tumor_vol = "TumorVolume",
  trt_control = "Control",
  drug_a = "DrugA",
  drug_b = "DrugB",
  combination = "Combination"
  ) 
# Get the estimates
lmmModel_estimates(lmm)
}
