% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features_07_claim_payment_time.R
\name{claim_payment_time}
\alias{claim_payment_time}
\title{Partial Payment Times (in Continuous Time Scale)}
\usage{
claim_payment_time(
  frequency_vector,
  occurrence_list,
  notification_list,
  payment_delay_list,
  discrete = FALSE
)
}
\arguments{
\item{frequency_vector}{a vector of claim frequencies for all the periods.}

\item{occurrence_list}{list of claim occurrence times.}

\item{notification_list}{list of notification delays.}

\item{payment_delay_list}{(compound) list of inter partial delays.}

\item{discrete}{logical; if TRUE returns integer-valued payment times
(default FALSE).}
}
\description{
Converts the list of inter-partial delays to a list of payment times in
continuous time scale. Set \code{discrete = TRUE} to get the payment times in
calendar periods.
}
\details{
Returns a compound list structure such that the \eqn{j}th component
of the \eqn{i}th sub-list gives the payment time pattern (as a vector) for
the \eqn{j}th claim of occurrence period \eqn{i}. \cr \cr
Note that, as in the case of \code{\link{claim_closure}}, this function can
result in out-of-bound payment dates (i.e. payment times beyond the maximum
number of development periods under consideration). In these cases, we retain
the original simulated values for the simulation of other quantities, but we
will make adjustments for such claims in the tabulation of results in
\code{\link{claim_output}} and the payment inflation function
\code{\link{claim_payment_inflation}}.
}
