% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taf.libPaths.R
\name{taf.libPaths}
\alias{taf.libPaths}
\title{Add TAF Library Path}
\usage{
taf.libPaths(remove = FALSE)
}
\arguments{
\item{remove}{whether to remove TAF library from the search path, instead of
adding it.}
}
\value{
The resulting vector of file paths.
}
\description{
Add TAF library to the search path for R packages.
}
\note{
Specifically, this function sets \code{"boot/library"} as the first element
of \code{.libPaths()}. This is rarely beneficial in TAF scripts, but can be
useful when using the \pkg{sessioninfo} package, for example.
}
\section{Warning}{

An unwanted side effect of having the TAF library as the first element in the
search path is that \code{install.packages} will then install packages inside
\verb{boot/library}. This is not a serious side effect, since a subsequent
call to \code{taf.boot} or  \code{clean.library} will remove packages from
the TAF library that are not declared in the \file{SOFTWARE.bib} file.
}

\examples{
\donttest{
taf.libPaths()
taf.libPaths(remove=TRUE)
}

}
\seealso{
\code{\link{.libPaths}} is the underlying function to modify the search path
for R packages.

\code{\link{taf.library}} loads a package from \verb{boot/library}.

\code{\link{TAF-package}} gives an overview of the package.
}
