% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PIPs_by_landmarking.R
\name{PIPs_by_landmarking}
\alias{PIPs_by_landmarking}
\title{Posterior inclusion probabilities (PIPs) by landmarking}
\usage{
PIPs_by_landmarking(fullModel, data, discreteSurv = TRUE, numberCores = 1,
  package = "nnet", maxit = 150, prior = "flat", method = "LEB",
  landmarkLength = 1, lastlandmark, timeVariableName)
}
\arguments{
\item{fullModel}{formula of the model including all potential variables}

\item{data}{the data frame with all the information}

\item{discreteSurv}{Boolean variable telling us whether a 'simple'
multinomial regression is looked for or if the goal is a discrete
survival-time model for multiple modes of failure is needed.}

\item{numberCores}{How many cores should be used in parallel?}

\item{package}{Which package should be used to fit the models; by default
the \code{nnet} package is used; we could also specify to use the package
'VGAM'}

\item{maxit}{Only needs to be specified with package \code{nnet}: maximal
number of iterations}

\item{prior}{Prior on the model space}

\item{method}{Method for the g definition}

\item{landmarkLength}{Length of the landmark, by default we use each day}

\item{lastlandmark}{Where will be the last landmark?}

\item{timeVariableName}{What is the name of the variable indicating time?}
}
\value{
a list with the PIPs for each landmark
}
\description{
This function gives us the PIPs for each landmark.
}
\examples{
# extract the data:
data("VAP_data")

# the definition of the full model with three potential predictors:
FULL <- outcome ~ ns(day, df = 4) + gender + type + SOFA
# here we define time as a spline with 3 knots

PIPs_landmark <- PIPs_by_landmarking(fullModel = FULL, data = VAP_data,
                                     discreteSurv = TRUE, numberCores = 1,
                                     package = 'nnet', maxit = 150,
                                     prior = 'flat',  method = 'LEB',
                                     landmarkLength = 7, lastlandmark = 21,
                                     timeVariableName = 'day')
}
\author{
Rachel Heyard
}
