% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_calculations.R
\name{distance_matrix}
\alias{distance_matrix}
\title{Compute a distance matrix from a list of persistence diagrams.}
\usage{
distance_matrix(
  diagrams,
  other_diagrams = NULL,
  dim = 0,
  distance = "wasserstein",
  p = 2,
  sigma = NULL,
  num_workers = parallelly::availableCores(omit = 1)
)
}
\arguments{
\item{diagrams}{a list of persistence diagrams, either the output of persistent homology calculations like \code{\link[TDA]{ripsDiag}}/\code{\link[TDAstats]{calculate_homology}}/\code{\link{PyH}}, or \code{\link{diagram_to_df}}.}

\item{other_diagrams}{either NULL (default) or another list of persistence diagrams to compute a cross-distance matrix.}

\item{dim}{the non-negative integer homological dimension in which the distance is to be computed, default 0.}

\item{distance}{a character determining which metric to use, either "wasserstein" (default) or "fisher".}

\item{p}{a number representing the wasserstein power parameter, at least 1 and default 2.}

\item{sigma}{a positive number representing the bandwidth of the Fisher information metric, default NULL.}

\item{num_workers}{the number of cores used for parallel computation, default is one less than the number of cores on the machine.}
}
\value{
the numeric distance matrix.
}
\description{
Calculate the distance matrix \eqn{d} for either a single list of persistence diagrams \eqn{(D_1,D_2,\dots,D_n)}, i.e. \eqn{d[i,j] = d(D_i,D_j)}, 
or between two lists, \eqn{(D_1,D_2,\dots,D_n)} and \eqn{(D'_1,D'_2,\dots,D'_n)}, \eqn{d[i,j] = d(D_i,D'_j)}, in parallel.
}
\details{
Distance matrices of persistence diagrams are used in downstream analyses, like in the 
\code{\link{diagram_mds}}, \code{\link{permutation_test}} and \code{\link{diagram_ksvm}} functions. 
If `distance` is "fisher" then `sigma` must not be NULL.
}
\examples{

if(require("TDA") & require("TDAstats"))
{
  # create two diagrams
  D1 <- TDAstats::calculate_homology(TDA::circleUnif(n = 10,r = 1),
                                     dim = 0,threshold = 2)
  D2 <- TDAstats::calculate_homology(TDA::circleUnif(n = 10,r = 1),
                                     dim = 0,threshold = 2)
  g <- list(D1,D2)

  # calculate their distance matrix in dimension 0 with the 2-wasserstein metric 
  # using 2 cores in dimension 1
  D <- distance_matrix(diagrams = g,dim = 0,distance = "wasserstein",p = 2,num_workers = 2)

  # now do the cross distance matrix, which is the same as the original
  D_cross <- distance_matrix(diagrams = g,other_diagrams = g,
                             dim = 0,distance = "wasserstein",
                             p = 2,num_workers = 2)
}
}
\author{
Shael Brown - \email{shaelebrown@gmail.com}
}
