% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func.R
\name{PlotFamilies}
\alias{PlotFamilies}
\title{Plot the age distributions or insertion rates for multiple families.}
\usage{
PlotFamilies(resList, type = c("insRt", "ageDist"), ...)
}
\arguments{
\item{resList}{A list of TEfit/TEfit2 objects, which can be mixed}

\item{type}{Whether to plot the insertion rates ('insRt') or the age distributions ('ageDist').}

\item{...}{Passed into plotting functions.}
}
\value{
A list of line data (plotDat) and peak locations (peakDat).
}
\description{
Plot the age distributions or insertion rates for multiple families.
}
\examples{
data(AetLTR)
copia3 <- subset(AetLTR, GroupID == 3 & !is.na(Chr))
gypsy24 <- subset(AetLTR, GroupID == 24 & !is.na(Chr))
res3 <- EstDynamics(copia3$Mismatch, copia3$UngapedLen)
res24 <- EstDynamics2(gypsy24$Mismatch, gypsy24$UngapedLen)

# Plot insertion rates
PlotFamilies(list(`Copia 3`=res3, `Gypsy 24`=res24))

# Plot age distributions
PlotFamilies(list(`Copia 3`=res3, `Gypsy 24`=res24), type='ageDist')
}
