% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsymm_t.R
\name{rsymm_t}
\alias{rsymm_t}
\title{Simulate Symmetric Matrices with Multivariate t Elements}
\usage{
rsymm_t(n, mean, df = 1, sigma = diag(length(vech(mean))))
}
\arguments{
\item{n}{Number of matrices to generate.}

\item{mean}{A symmetric matrix specifying the mean of the distribution.}

\item{df}{Degrees of freedom for the t distribution.}

\item{sigma}{The scale parameter matrix for the elements arranged by \code{\link[=vech]{vech()}}. \code{sigma} is passed to \code{\link[mvtnorm:Mvt]{mvtnorm::rmvt()}} without any transformation.}
}
\value{
A set of flattened symmetric matrices as a \code{TFORGE_fsm} object. See \code{\link[=as_fsm]{as_fsm()}}.
}
\description{
Simulate symmetric matrices with elements from a multivariate t distribution.
}
\details{
The function uses Representation A in \insertCite{lin1972ch}{TFORGE} to simulate multivariate-t vectors.
The mean matrix is vectorised using the \code{\link[=vech]{vech()}} function
and then used as the mean vector in the \code{\link[mvtnorm:Mvt]{mvtnorm::rmvt()}} function.
The scale parameter matrix \code{sigma} is passed unchanged to \code{\link[mvtnorm:Mvt]{mvtnorm::rmvt()}}.
The covariance of the resulting vectors is \code{sigma * df / (df - 2)}.
Symmetric matrices can be obtained by applying \code{\link[=inv_vech]{inv_vech()}} to each simulated vector.
}
\examples{
rsymm_t(100, mean = matrix(1, nrow = 3, ncol = 3), df = 10, sigma = diag(c(3,2,1,1,1,1)))

}
\references{
\insertAllCited{}
}
