% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p.tpm.omni.R
\name{p.tpm.omni}
\alias{p.tpm.omni}
\title{CDF of omnibus truncated product method statistic under the null hypothesis.}
\usage{
p.tpm.omni(q, n, TAU1)
}
\arguments{
\item{q}{- quantile, could be a vector.}

\item{n}{- dimension parameter, i.e. the number of p-values to be combined.}

\item{TAU1}{- a vector of truncation parameters. Must be in non-descending order.}
}
\value{
The left-tail probability of the null distribution of omnibus truncated product method statistic.
}
\description{
CDF of omnibus truncated product method statistic under the null hypothesis.
}
\examples{
q = 0.05
n = 20
TAU1 = c(0.01, 0.05, 0.5, 1)
p.tpm.omni(q=q, n=n, TAU1=TAU1)
}
\references{
1. Hong Zhang and Zheyang Wu. "Optimal Thresholding of Fisher's P-value Combination
Tests for Signal Detection", submitted.
}
\seealso{
\code{\link{stat.tpm.omni}} for the definition of the statistic.
}
