% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q.tfisher.R
\name{q.tfisher}
\alias{q.tfisher}
\title{Quantile of thresholding Fisher's p-value combination statistic under the null hypothesis.}
\usage{
q.tfisher(p, n, tau1, tau2)
}
\arguments{
\item{p}{-  a scalar left probability that defines the quantile.}

\item{n}{- dimension parameter, i.e. the number of input p-values.}

\item{tau1}{- truncation parameter. 0 < tau1 <= 1.}

\item{tau2}{- normalization parameter. tau2 >= tau1.}
}
\value{
Quantile of thresholding Fisher's p-value combination statistic.
}
\description{
Quantile of thresholding Fisher's p-value combination statistic under the null hypothesis.
}
\examples{
## The 0.05 critical value of TFisher statistic when n = 10:
q.tfisher(p=.95, n=10, tau1 = 0.05, tau2 = 0.25)
}
\references{
1. Hong Zhang and Zheyang Wu. "Optimal Thresholding of Fisher's P-value Combination
Tests for Signal Detection", submitted.
}
\seealso{
\code{\link{stat.tfisher}} for the definition of the statistic.
}
