\name{tepBADA.inference.battery}
\alias{tepBADA.inference.battery}
\encoding{UTF-8}
\title{
	Barycentric Discriminant Analysis Inference Battery
}
\description{
Barycentric Discriminant Analysis (BADA) Inference Battery via TInPosition.
}
\usage{
tepBADA.inference.battery(DATA, scale = TRUE, center = TRUE, DESIGN = NULL, 
	make_design_nominal = TRUE, 
	group.masses = NULL, ind.masses = NULL, weights = NULL, 
	graphs = TRUE, k = 0, 
	test.iters = 100, critical.value = 2)
}
\arguments{
    \item{DATA}{original data to perform a BADA on.}
  \item{scale}{a boolean, vector, or string. See \code{\link{expo.scale}} for details.}
  \item{center}{a boolean, vector, or string. See \code{\link{expo.scale}} for details.}
  \item{DESIGN}{a design matrix to indicate if rows belong to groups. Required for BADA.}
  \item{make_design_nominal}{a boolean. If TRUE (default), DESIGN is a vector that indicates groups (and will be dummy-coded). If FALSE, DESIGN is a dummy-coded matrix.}
  \item{group.masses}{a diagonal matrix or column-vector of masses for the groups.}
  \item{ind.masses}{a diagonal matrix or column-vector of masses for the individuals (rows).}
  \item{weights}{a diagonal matrix or column-vector of weights for the column items.}
  \item{graphs}{a boolean. If TRUE (default), graphs and plots are provided (via \code{\link{epGraphs}})}
  \item{k}{number of components to return.}
  \item{test.iters}{number of iterations}
  \item{critical.value}{numeric. A value, analogous to a z- or t-score to be used to determine significance (via bootstrap ratio).}
}
\details{
	\code{tepBADA.inference.battery} performs barycentric discriminant analysis and inference tests on based on data and (row) design matrices. \cr\cr
	If the expected time to compute the results (based on \code{test.iters}) exceeds 1 minute, you will be asked (via command line) if you want to continue. 
}
\value{
Returns two lists ($Fixed.Data and $Inference.Data). For $Fixed.Data, see \code{\link{tepBADA}} and \code{\link{corePCA}} for details on the descriptive (fixed-effects) results.

$Inference.Data returns:
\item{omni}{Permutation tests of components. p-values ($p.val) and distributions of total inertia ($inertia.perm)}
\item{r2}{Permutation tests of R-squared value. p-values ($p.val) and distributions of R2s ($r2.perm)}
\item{components}{Permutation tests of components. p-values ($p.vals) and distributions of eigenvalues ($eigs.perm) for each component}
\item{boot.data}{Bootstrap tests for $fi and $fj. Contains distributions. See also \code{\link{boot.ratio.test}} output details.}
\item{loo.data}{Leave one out cross-validation tests. Includes assignments ($loo.assign), factor scores ($loo.fii),
	LOO and fixed confusion matrices ($loo.confuse, $fixed.confuse), and accuracy ($loo.acc, $fixed.acc)}
}
\author{
Derek Beaton, Jenny Rieck, Hervé Abdi
}
\examples{
	data(bada.wine)
	data<-bada.wine$data
	design <- bada.wine$design
	bada.res <- 
		tepBADA.inference.battery(data,scale=FALSE,DESIGN=design,
			make_design_nominal=FALSE,test.iters=50)
}
\keyword{ multivariate }