% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TKCat.R, R/chMDB.R, R/chTKCat.R, R/fileMDB.R,
%   R/generics.R, R/memoMDB.R, R/metaMDB.R
\name{collection_members.TKCat}
\alias{collection_members.TKCat}
\alias{collection_members.chMDB}
\alias{collection_members<-.chMDB}
\alias{collection_members.chTKCat}
\alias{collection_members.fileMDB}
\alias{collection_members<-.fileMDB}
\alias{collection_members}
\alias{collection_members<-}
\alias{collection_members.memoMDB}
\alias{collection_members<-.memoMDB}
\alias{collection_members.metaMDB}
\title{Collection members}
\usage{
\method{collection_members}{TKCat}(x, ...)

\method{collection_members}{chMDB}(x, ...)

\method{collection_members}{chMDB}(x) <- value

\method{collection_members}{chTKCat}(x, ...)

\method{collection_members}{fileMDB}(x, ...)

\method{collection_members}{fileMDB}(x) <- value

collection_members(x, ...)

collection_members(x) <- value

\method{collection_members}{memoMDB}(x, ...)

\method{collection_members}{memoMDB}(x) <- value

\method{collection_members}{metaMDB}(x, ...)
}
\arguments{
\item{x}{an object with embedded collection members}

\item{...}{names of the collections
to focus on. By default, all of them are taken.}

\item{value}{the new collection members.
A data.frame with the following columns:
\itemize{
\item \strong{collection} (character): The name of the collection
\item \strong{cid} (character): Collection identifier
\item \strong{resource} (character): The name of the resource
\item \strong{mid} (integer): The identifier of the member
\item \strong{table} (character): The table recording collection information
\item \strong{field} (character): The collection field.
\item \strong{static} (logical): TRUE if the field value is common to all elements.
\item \strong{value} (character): The name of the table column if static is FALSE
or the field value if static is TRUE.
\item \strong{type} (character): the type of the field.
(not necessarily used ==> NA if not)
}}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with the following columns:
\itemize{
\item \strong{collection} (character): The name of the collection
\item \strong{cid} (character): Collection identifier
\item \strong{resource} (character): The name of the resource
\item \strong{mid} (integer): The identifier of the member
\item \strong{table} (character): The table recording collection information
\item \strong{field} (character): The collection field.
\item \strong{static} (logical): TRUE if the field value is common to all elements.
\item \strong{value} (character): The name of the table column if static is FALSE
or the field value if static is TRUE.
\item \strong{type} (character): the type of the field.
(not necessarily used ==> NA if not)
}
}
\description{
Collection members

Collection members
}
