% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_tlmcov.R
\name{est_tlmcov}
\alias{est_tlmcov}
\alias{est_tlmcov.numeric}
\alias{est_tlmcov.matrix}
\alias{est_tlmcov.TLMoments}
\title{Estimate the covariance matrix of TL-moments estimations}
\usage{
est_tlmcov(x, leftrim = 0L, rightrim = 0L, order = 1:3, distr = NULL,
  lambda.cov = TRUE, ratio.cov = TRUE, ...)

\method{est_tlmcov}{numeric}(x, leftrim = 0L, rightrim = 0L, order = 1:3,
  distr = NULL, lambda.cov = TRUE, ratio.cov = TRUE, ...)

\method{est_tlmcov}{matrix}(x, leftrim = 0L, rightrim = 0L, order = 1:3,
  distr = NULL, lambda.cov = TRUE, ratio.cov = TRUE, reg.weights = NULL,
  ...)

\method{est_tlmcov}{TLMoments}(x, leftrim = attr(x, "leftrim"),
  rightrim = attr(x, "leftrim"), order = attr(x, "order"), distr = NULL,
  lambda.cov = TRUE, ratio.cov = TRUE, set.n = NA, ...)
}
\arguments{
\item{x}{numeric vector or matrix containing data OR an object of TLMoments.}

\item{leftrim, rightrim}{integer indicating lower and upper trimming parameters, have to be non-negative integers.}

\item{order}{numeric vector giving the orders that are returned (default is first three L-moments).}

\item{distr}{character of length 1 giving the distribution if parametric assumption should be used.}

\item{lambda.cov}{boolean, if TRUE (default) TL-moment estimation covariance matrix is calculated.}

\item{ratio.cov}{boolean, if TRUE (default) TL-moment-ratio estimation covariance matrix is calculated.}

\item{...}{additional arguments, ignored.}

\item{reg.weights}{numeric vector of weights for regionalized TLMoments.}

\item{set.n}{hypothetical data length n if theoretical values are given.}
}
\value{
a list of numeric matrices (if \code{lambda.cov} and \code{ratio.cov} are TRUE (default)), or a single matrix.
}
\description{
Internal function. Use \link{est_cov}. Description not done yet.
}
\examples{
### Numeric vectors
x <- rgev(500, loc = 10, scale = 5, shape = .1)

est_tlmcov(x)
est_tlmcov(x, order = 2:3)
est_tlmcov(x, rightrim = 1, order = 4:5)
# cov(t(replicate(10000, TLMoments(rgev(500, loc = 10, scale = 5, shape = .1))$lambdas)))
# cov(t(replicate(10000, TLMoments(rgev(500, loc = 10, scale = 5, shape = .1))$ratios)))

est_tlmcov(x, ratio.cov = FALSE)
est_tlmcov(x, lambda.cov = FALSE)

est_tlmcov(x, distr = "gev")

est_tlmcov(x, leftrim = 0, rightrim = 1)
# cov(t(replicate(10000,
#  TLMoments(rgev(500, loc = 10, scale = 5, shape = .1), 0, 1, 3)$lambdas
# )))
# cov(t(replicate(10000,
#  TLMoments(rgev(500, loc = 10, scale = 5, shape = .1), 0, 1, 3)$ratios
# )))

### Numeric matrices
x <- matrix(rgev(600), nc = 3)

est_tlmcov(x)
est_tlmcov(x, order = 3:4)
# cov(t(replicate(10000, as.vector(TLMoments(matrix(rgev(600), nc = 3))$lambdas[3:4, ]))))
# cov(t(replicate(10000, as.vector(TLMoments(matrix(rgev(600), nc = 3))$ratios[3:4, ]))))

est_tlmcov(x, ratio.cov = FALSE)
est_tlmcov(x, lambda.cov = FALSE)

TLMoments:::est_tlmcov(x, order = 2:3, distr = "gev")
# cov(t(replicate(10000, as.vector(TLMoments(matrix(rgev(600), nc = 3))$lambdas[2:3, ]))))
# cov(t(replicate(10000, as.vector(TLMoments(matrix(rgev(600), nc = 3))$ratios[2:3, ]))))

### TLMoments-object (theoretical calculation)
tlm <- TLMoments(as.parameters(loc = 10, scale = 5, shape = .1, distr = "gev"), 0, 1)
est_tlmcov(tlm, distr = "gev", set.n = 100)
est_tlmcov(tlm, distr = "gev", set.n = 100, ratio.cov = FALSE)
est_tlmcov(tlm, distr = "gev", set.n = 100, lambda.cov = FALSE)

}
