% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_align.peaks.R
\name{mod_align.peaks}
\alias{mod_align.peaks}
\title{Aligning the TL peaks}
\usage{
mod_align.peaks(object, aligning.parameters = list(peak.Tmin = 0, peak.Tmax =
  NA, no.testdose = FALSE), plotting.parameters = list(plot.Tmin = 0,
  plot.Tmax = NA, no.plot = FALSE))
}
\arguments{
\item{object}{\code{\linkS4class{TLum.Analysis}} (\bold{required}): object containing the TL curves that have to be aligned.}

\item{aligning.parameters}{\link{list} (with default): list containing the aligning parameters. See details.}

\item{plotting.parameters}{\link{list} (with default): list containing the plotting parameters. See details.}
}
\value{
This function provides a new \code{\linkS4class{TLum.Analysis}} object with the same TL curves but aligned. \cr
 It also plots the original TL curves, the TL curves used to determine the peak maximum position, and the shiffted TL curves using \link{plot_align.peaks}.
}
\description{
This function detects the peak position for each TL curve of the object and aligns them.
It uses the average of the testdose maximum positions as reference for the new peak position.
}
\details{
\bold{Aligning parameters} \cr
 The aligning parameters are:  \cr
 \describe{
 \item{\code{peak.Tmin}}{
   \link{numeric}: Lower boundary for looking at the peak maximum position.}
 \item{\code{peak.Tmax}}{
   \link{numeric}: Upper boundary for looking at the peak maximum position.}
 \item{\code{no.testdose}}{
   \link{logical}: If \code{TRUE}, the function will use the Lx curves rather than the Tx curves as reference for the peak maximum position.}
 }

 \bold{Plotting parameters} \cr
 The plotting parameters are:  \cr
 \describe{
 \item{\code{no.plot}}{
   \link{logical}: If \code{TRUE}, the results will not be plotted.}
}
}
\author{
David Strebler, University of Cologne (Germany).
}
\seealso{
\link{plot_align.peaks}.
}

