% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_LocalTest.R
\name{adjust_LocalTest}
\alias{adjust_LocalTest}
\title{Adjust all p-values using a Closed Testing Procedure and a
user-defined local test which satisfies the quadratic shortcut given in Mogensen and Markussen (2021)}
\usage{
adjust_LocalTest(
  LocalTest,
  pvals,
  alpha = 0.05,
  is.sorted = FALSE,
  EarlyStop = FALSE,
  verbose = FALSE,
  mc.cores = 1L,
  chunksize = 4 * mc.cores,
  direction = "increasing",
  parallel.direction = "breadth",
  AdjustAll = FALSE,
  ...
)
}
\arguments{
\item{LocalTest}{A function specifying a local test.}

\item{pvals}{vector of p-values.}

\item{alpha}{significance level. Defaults to 0.05.}

\item{is.sorted}{Logical, indicating whether the supplied p-values are already
sorted. Defaults to FALSE.}

\item{EarlyStop}{Logical; set to TRUE to stop as soon as a hypothesis can be
accepted at level alpha. This speeds up the procedure, but now only provides
upper bounds on the adjusted p-values that are below alpha.}

\item{verbose}{Logical; set to TRUE to print progress. Defaults to FALSE.}

\item{mc.cores}{Number of cores to parallelize onto.}

\item{chunksize}{Integer indicating the size of chunks to parallelize. E.g.,
if setting chunksize = mc.cores, each time a parallel computation is set up,
each worker will perform only a single task. If mc.cores > chunksize, some
threads will be inactive.}

\item{direction}{String that is equal to either "increasing"/"i", "decreasing"/"d" or "binary"/"b".
Determines the search direction. When set to"increasing", the function computes the exact adjusted p-value
for all those hypotheses that can be rejected (while controlling the FWER),
but is potentially slower than "decreasing". "decreasing"identifies all hypotheses that can
be rejected with FWER control, but does not compute the actual adjusted p-values.
"binary" performs a binary search for the number of hypotheses
that can be rejected with FWER control.  Defaults to "increasing". Note that
'binary' does not work with parallel.direction == 'breadth'.}

\item{parallel.direction}{A string that is either "breadth" or "depth"
(or abbreviated to "b" or "d), indicating in which direction to parallelize.
Breadth-first parallelization uses a more efficient C++ implementation to
adjust each p-value, but depth-first parallelization potentially finishes
faster if using early stopping (EarlyStop = TRUE) and very few hypotheses
can be rejected.}

\item{AdjustAll}{Logical, indicating whether to adjust all p-values (TRUE)
or only those that are marginally significant (FALSE). Defaults to FALSE.}

\item{...}{Additional arguments.}
}
\value{
a data.frame containing adjusted p-values and their respective indices.
If direction == 'decreasing' or 'binary', an integer describing the number of
hypotheses that can be rejected with FWER control is returned.
}
\description{
Adjust all p-values using a Closed Testing Procedure and a
user-defined local test which satisfies the quadratic shortcut given in Mogensen and Markussen (2021)
}
\examples{
p = sort(runif(100)) # Simulate and sort p-values
p[1:10] = p[1:10]**3 # Make the bottom 10 smaller, such that they correspond to false hypotheses
adjust_LocalTest(
  LocalTest = function(x) {
    min(c(1, length(x) * min(x)))
  },
  p, alpha = 0.05, is.sorted = TRUE
)
}
