% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma_bootstrapper_Ttest.R
\name{gamma_bootstrapper_Ttest}
\alias{gamma_bootstrapper_Ttest}
\title{Compute a list of TMTI CDFs for one- and two-sample test scenarios}
\usage{
gamma_bootstrapper_Ttest(
  Y,
  X = NULL,
  n = Inf,
  B = 1000,
  mc.cores = 1L,
  tau = NULL,
  K = NULL
)
}
\arguments{
\item{Y}{A d*m matrix of m response variables with d observations. Can
contain missing values in places.}

\item{X}{Null if one-sample, a vector with only two unique values if
two-sample.}

\item{n}{Number (or Inf) indicating what kind of minimum to consider.
Defaults to Inf, corresponding to the global minimum.}

\item{B}{Number of bootstrap replicates. Rule of thumb is to use at least
10 * m.}

\item{mc.cores}{Integer denoting the number of cores to use when using
parallelization, Defaults to 1, corresponding to single-threaded computations.}

\item{tau}{Numerical (in (0,1)); threshold to use in tTMTI. If set to NULL,
then either TMTI (default) or rtTMTI is used.}

\item{K}{Integer; Number of smallest p-values to use in rtTMTI. If se to NULL,
then either TMTI (default) or tTMTI is used.}
}
\value{
A list of bootstrapped TMTI CDFs that can be used directly in the
CTP_TMTI function.
}
\description{
Compute a list of TMTI CDFs for one- and two-sample test scenarios
}
\examples{
d = 100
m = 3

X = sample(LETTERS[1:2], d, replace = TRUE)
Y = matrix(rnorm(d * m), nrow = d, ncol = m)
pvalues = apply(Y, 2, function(y) t.test(y ~ X)$p.value)

gammaFunctions = gamma_bootstrapper_Ttest(Y, X) # Produces a list of CDFs
CTP_TMTI(pvalues, gammaList = gammaFunctions) # Adjusted p-values using the bootstrapped CDFs

}
