% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TOSTone.raw.R
\name{TOSTone.raw}
\alias{TOSTone.raw}
\title{TOST function for a one-sample t-test (raw scores)}
\usage{
TOSTone.raw(m, mu, sd, n, low_eqbound, high_eqbound, alpha)
}
\arguments{
\item{m}{mean}

\item{mu}{value to compare against}

\item{sd}{standard deviation}

\item{n}{sample size}

\item{low_eqbound}{lower equivalence bounds (e.g., -0.5) expressed in raw units}

\item{high_eqbound}{upper equivalence bounds (e.g., 0.5) expressed in raw units}

\item{alpha}{alpha level (default = 0.05)}
}
\value{
Returns TOST t-value 1, TOST p-value 1, TOST t-value 2, TOST p-value 2, degrees of freedom, low equivalence bound, high equivalence bound, Lower limit confidence interval TOST, Upper limit confidence interval TOST
}
\description{
TOST function for a one-sample t-test (raw scores)
}
\examples{
## Test observed mean of 0.52 and standard deviation of 0.52 in sample of 300 participants
## against 0.5 given equivalence bounds in raw units of -0.1 and 0.1, with an alpha = 0.05.
TOSTone.raw(m=0.52,mu=0.5,sd=0.5,n=300,low_eqbound=-0.1, high_eqbound=0.1, alpha=0.05)
}
