% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPLS.R
\name{TPLS}
\alias{TPLS}
\title{Constructor method for fitting a T-PLS model with given data X and Y.}
\usage{
TPLS(X, Y, NComp = 25, W = NULL, nmc = 0)
}
\arguments{
\item{X}{Numerical matrix of predictors. Typically single-trial betas where each column is a voxel and row is observation}

\item{Y}{Variable to predict. Binary 0 and 1 in case of classification, continuous variable in case of regression}

\item{NComp}{(Optional) Number of PLS components to compute. Default is 25.}

\item{W}{(Optional) Observation weights. By default, all observations have equal weight.}

\item{nmc}{(Optional) 'no mean centering'. Default is 0. If 1, T-PLS will skip mean-centering. This option is only provided in case you already mean-centered the data and want to save some memory usage.}
}
\value{
A TPLS object that contains the following attributes. Most of the time, you won't need to access the attributes.
\itemize{
    \item \code{NComp}: The number of components you specified in the input
    \item \code{W}: Normalized version of the observation weights (i.e., they sum to 1)
    \item \code{MtrainX}: Column mean of X. Weighted mean if W is given.
    \item \code{MtrainY}: Mean of Y. Weighted mean if W is given.
    \item \code{scoreCorr}: Correlation between Y and each PLS component. Weighted correlation if W is given.
    \item \code{pctVar}: Proportion of variance of Y that each component explains.
    \item \code{betamap}: v-by-NComp matrix of TPLS coefficients for each of the v variables, provided at each model with NComp components.
    \item \code{threshmap} : v-by-NComp matrix of TPLS threshold values (0~1) for each of the v variables, provided at each model with NComp components.
}
See vignettes for tutorial
}
\description{
Constructor method for fitting a T-PLS model with given data X and Y.
}
