% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPMplt.R
\name{basic3d}
\alias{basic3d}
\title{3D plots without labels}
\usage{
basic3d(x, gain = 100, division = 5, clrctrl = c("heat", "terrain",
  "topo", "cm", "rainbow"), zeroplane = TRUE)
}
\arguments{
\item{x}{An "PLTbuilder" object.}

\item{gain}{A positive integer to gain gradual colours. Default value is 100.}

\item{division}{Subdivision numbers for x, y and z axises.}

\item{clrctrl}{Color control. Optinal value are "rainbow", "heat", "terrain", "topo" and "cm".}

\item{zeroplane}{Boolean value to control for adding the plane of z=0. Default setting is TRUE.}
}
\value{
A surface 3d plot.
}
\description{
3D plots without labels
}
\examples{
epstable <- epsExtract(TPMdata, 0.7, 2, 3)
DMM <- DMMprocess(epstable)
PLTbd <- SVRModel(DMM)
PLT3dbd <- surfacebld(PLTbd, "eta")
basic3d(PLT3dbd, clrctrl="cm")
}
\keyword{internal}
