% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_map.R
\name{plot_map}
\alias{plot_map}
\title{Visualize Spatial(Cross-Section) Data of a Given Time Point - 2D Map}
\usage{
plot_map(newdata, xlab = NULL, ylab = NULL, title = NULL, cex = 2,
  shape = 15, low = "blue", mid = "yellow", high = "red",
  na.value = "white", midpoint = NULL)
}
\arguments{
\item{newdata}{data frame; should only contain the three variables in order: X coordinate, Y coordinate and observation.
This is the cross-section data or pure spatial data of a particular time point you have selected,
with missing observations that you want to predict. (coordinates must be numeric)}

\item{xlab}{a label for the x axis, defaults to the name of X coordinate.}

\item{ylab}{a label for the y axis, defaults to the name of Y coordinate.}

\item{title}{a main title for the plot.}

\item{cex}{numeric; size of plotting point for each spatial locations. (default: 2)}

\item{shape}{either an integer specifying a symbol or a single character to be used as the default
in plotting points. (default: 15)}

\item{low, high}{colours for low and high ends of the gradient. (default: "blue","red")}

\item{mid}{colour for midpoint of the gradient. (default: "yellow")}

\item{na.value}{colour for missing values/observations. (default: "white")}

\item{midpoint}{numeric; the midpoint of the gradient scale, defaults to the midpoint value of index presented.}
}
\description{
\code{plot_map} draws a two-dimensional spatial map. It is plotted based on the cross-section data
  of a given time point, which is also often extracted from spatio-temporal data.
}
\details{
\code{plot_map} is exclusive to 2D rectangular grid system. Similarly, if you want to fathom how this package
  handles 3D rectangular grid system, please refer to \code{plot3D_map}.
}
\examples{
\dontrun{

## TSCS spatial interpolation procedure:

basis <- tscsRegression(data = data, h = 1, v = 1, alpha = 0.01); # regression
basis$percentage # see the percentage of cointegrated relationships
est <- tscsEstimate(matrix = basis$coef_matrix, newdata = newdata, h = 1, v = 1); # estimation
str(est)

## comparison of estimates and true values:

plot_compare(est = est$estimate[,3], true = true) # graphic comparison
index <- appraisal_index(est = est$estimate[,3], true = true); # RMSE & std
index

## data visualization:

plot_dif(data = data[,1:2], h = 1, v = 1) # differentiate boundary and interior spatial locations
plot_NA(newdata = newdata) # show spatial locations with missing value, for a cross-section data
plot_map(newdata = newdata) # plot the 2D spatial map, for a cross-section data
}
}
\seealso{
\code{plot3D_map}, \code{plot_NA}, \code{plot_dif}
}
