% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tscsRegression.R
\name{tscsRegression}
\alias{tscsRegression}
\title{The First Step of TSCS for 2D Rectangular Grid System - Regression}
\usage{
tscsRegression(data, h, v, alpha = 0.05)
}
\arguments{
\item{data}{data frame; should contain these variables in order: X coordinate, Y coordinate and observations
as time goes on. That is to say, each row should include X and Y coordinate first, and then a time series.
This is the historical spatio-temporal data that you intend to analyze as the basis for
interpolation later on in \code{tscsEstimate}.}

\item{h}{numeric; side length of the unit grid in X coordinate direction.}

\item{v}{numeric; side length of the unit grid in Y coordinate direction.}

\item{alpha}{numeric; specify the significance level for ADF test, to test if the time series of a group of
spatial locations are cointegrated. (default: 0.05)}
}
\value{
A list of 2 is returned, including:
\describe{
  \item{\code{coef_matrix}}{data frame; regression coefficient matrix to be used as input parameter of function
  \code{tscsEstimate} in the second step of TSCS interpolation.}
  \item{\code{percentage}}{numeric; percentage of cointegrated relationships, a measurement of the degree
  it satisfies the assumption of cointegrated system. It is highly affected by parameter \code{alpha},
  the significance level you have set. Explicitly, smaller \code{alpha} results in smaller \code{percentage}.}
}
}
\description{
To implement TSCS spatial interpolation for a spatial domain that is a 2D rectangular grid system,
  the first step is obtaining regression coefficient matrix, which can be done
  by function \code{tscsRegression}. It is the prerequisite of TSCS interpolation process
  because the 'matrix' derived from historical spatio-temporal data is the initial value of
  the second step - estimating missing observations.
}
\details{
\itemize{
  \item The second step of TSCS spatial interpolation should be carried out by function \code{tscsEstimate},
  where you have to input the cross-section data or pure spatial data of a particular time point
  you have selected, with missing observations that you want to predict.
  \item For 3D rectangular grid system, the procedure of TSCS stays the same.
  Please see \code{tscsRegression3D} and \code{tscsEstimate3D}.
  \item Attentions:
  (1) Since TSCS is only capable of interpolation but not extrapolation, it is necessary to highlight the
  difference between interior spatial locations and system boundary. Function \code{plot_dif} can help.
  (2) NA value in historical spatio-temporal data \code{data} is not allowed. Please handle them beforehand
  (such as filling these NA values through spatio-temporal kriging).
}
}
\examples{
\dontrun{

## TSCS spatial interpolation procedure:

basis <- tscsRegression(data = data, h = 1, v = 1, alpha = 0.01); # regression
basis$percentage # see the percentage of cointegrated relationships
est <- tscsEstimate(matrix = basis$coef_matrix, newdata = newdata, h = 1, v = 1); # estimation
str(est)

## comparison of estimates and true values:

plot_compare(est = est$estimate[,3], true = true) # graphic comparison
index <- appraisal_index(est = est$estimate[,3], true = true); # RMSE & std
index

## data visualization:

plot_dif(data = data[,1:2], h = 1, v = 1) # differentiate boundary and interior spatial locations
plot_NA(newdata = newdata) # show spatial locations with missing value, for a cross-section data
plot_map(newdata = newdata) # plot the 2D spatial map, for a cross-section data
}
}
\seealso{
\code{tscsEstimate}, \code{tscsRegression3D}, \code{plot_dif}
}
