% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSE.r
\name{MSE}
\alias{MSE}
\title{MSE error of prediction}
\usage{
MSE(actual, prediction)
}
\arguments{
\item{actual}{A vector or univariate time series containing actual values
for a time series that are to be compared against its respective
predictions.}

\item{prediction}{A vector or univariate time series containing time series
predictions that are to be compared against the values in \code{actual}.}
}
\value{
A numeric value of the MSE error of prediction.
}
\description{
The function calculates the MSE error between actual and predicted values.
}
\examples{

data(SantaFe.A,SantaFe.A.cont)
pred <- marimapred(SantaFe.A,n.ahead=100)
MSE(SantaFe.A.cont[,1], pred)

}
\references{
Z. Chen and Y. Yang, 2004, Assessing forecast accuracy measures,
Preprint Series, n. 2004-2010, p. 2004-10.
}
\seealso{
\code{\link{NMSE}},\code{\link{MAPE}},\code{\link{sMAPE}},
\code{\link{MAXError}}
}
\author{
Rebecca Pontes Salles
}
\keyword{MSE}
\keyword{error}
\keyword{prediction}
