% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_core.R
\name{qca_extract}
\alias{qca_extract}
\title{Extract solution information from a QCA minimization result}
\usage{
qca_extract(sol, extract_mode = c("first", "all", "essential"))
}
\arguments{
\item{sol}{A solution object returned by \code{QCA::minimize()}.}

\item{extract_mode}{Character. How to handle multiple intermediate solutions:
\itemize{
  \item \code{"first"} - return only the first solution (M1). Default.
  \item \code{"all"} - return all solutions concatenated.
  \item \code{"essential"} - return essential prime implicants (terms 
    common to all solutions), plus selective prime implicants and 
    solution count.
}}
}
\value{
A list with elements depending on \code{extract_mode}.

  For \code{"first"}: \code{expression}, \code{inclS}, \code{covS}.

  For \code{"all"}: adds \code{n_solutions}.

  For \code{"essential"}: adds \code{selective_terms}, \code{unique_terms},
  \code{n_solutions}.

  If extraction fails, returns \code{"No solution"} and \code{NA_real_}
  for numeric values.
}
\description{
Internal helper to obtain the solution expression, consistency
(\code{inclS}) and coverage (\code{covS}) from an object returned by
\code{QCA::minimize()}.
}
\keyword{internal}
