% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ACPcalculator.R
\name{ACP.calculator}
\alias{ACP.calculator}
\title{Antecedental Rainfall (and temperature) Accumulation calculator for the VI Complete Time Series}
\usage{
ACP.calculator(
  CTSR.VI,
  ACP.table,
  ACT.table = NULL,
  allow.negative = FALSE,
  allowneg.retest = FALSE
)
}
\arguments{
\item{CTSR.VI}{Complete Monthly Time Series of Vegetation Index values.
An object of class \code{'ts'} object without NA's.}

\item{ACP.table}{A table of every combination of offset period and accumulation period.for precipitation
ACP.table can be calculated using the \code{\link{climate.accumulator}}.}

\item{ACT.table}{A table of every combination of offset period and accumulation period.for temperature
ACP.table can be calculated using the \code{\link{climate.accumulator}}.}

\item{allow.negative}{If true, will not preference positive slope in either CTSR or VI calculations. default=FALSE is set
because negative associations between rainfall and vegetation in water limited ecosystems is unexpected
If temperature data is included then this paramter is forced to TRUE.}

\item{allowneg.retest}{default=FALSE
If temperature data is provided but found to not be significant then a retest is performed.
This paramter is to allow negative on re-test.}
}
\value{
A list containing:

\bold{summary}
       a Matrix containing "slope", "intercept", "p.value", "R^2.Value", "Break.Height", "Slope.Change"
       of the \code{\link[stats]{lm}} between Antecedental Rainfall Accumulation (CTSR.RF) and the CTSR.VI

\bold{CTSR.precip}
       see CTSR.RF in \code{\link{TSSRESTREND}} for description

\bold{CTSR.osp}
       The offest period for the complete time series rainfall

\bold{CTSR.acp}
       The accumulation period for the complete time series rainfall

\bold{CTSR.tmp}
       The optimally accumulated CTS temperature

\bold{CTSR.tosp}
       The offest period for the complete time series temperature

\bold{CTSR.tacp}
       The accumulation period for the complete time series temperature
}
\description{
Takes the Complete Time Series Vegetation Index and a table of every possible accumulation period and offset
period for precipitation and temperature(optional).  A OLS is calculated \code{\link{lm}} for every combination
of VI ~ rainfall (and temperature if that is included).
if only the VPR is being calculated, this Function preferences those results where slope>0
(increase in rainfall causes an increase in vegetation),returning the rainfall accumulation
that has the highest R-squared and a positive slope. If no combination produces a
positive slope then the one with the highest R-squared is returned.
}
\examples{
#Find the data
vi.path <- system.file("extdata", "rabbitVI.csv", package = "TSS.RESTREND", mustWork = TRUE)
in.VI <- read.csv(vi.path)
CTSR.VI <- ts(in.VI, start=c(1982, 1), end=c(2013,12), frequency = 12)
data(rabbitACPtable)
ACPres <- ACP.calculator(CTSR.VI, rabbitACPtable)
print(ACPres$summary)
}
