% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDxoR.r
\name{E_HDxoR_HmDm_Ht.f}
\alias{E_HDxoR_HmDm_Ht.f}
\alias{HxoR_root.f}
\title{Find Height of diameter under bark via uniroot}
\usage{
E_HDxoR_HmDm_Ht.f(DxoR, Hm, Dm, mHt, sHt = 0, par.lme, Rfn = NULL, ...)

HxoR_root.f(Hx, DxoR, Hm, Dm, mHt, sHt, par.lme, Rfn, ...)
}
\arguments{
\item{DxoR}{Scalar. Diameter under bark for which to return height.}

\item{Hm}{Numeric vector of stem heights (m) along which diameter
measurements were taken for calibration. Can be of length 1. Must be of same
length as \code{Dm}.}

\item{Dm}{Numeric vector of diameter measurements (cm) taken for calibration.
Can be of length 1. Must be of same length as \code{Hm}.}

\item{mHt}{Scalar. Tree height (m).}

\item{sHt}{Scalar. Standard deviation of stem height. Can be 0 if height was
measured without error.}

\item{par.lme}{List of taper model parameters obtained by
\code{\link[TapeR]{TapeR_FIT_LME.f}}, enhanced by the attribute 'spp', which
refers to the tree species used for double bark thickness}

\item{Rfn}{setting for residuals error matrix, defaults to \code{"sig2"}, see
details.}

\item{...}{not currently used}

\item{Hx}{height at which taper curve is evaluated}
}
\value{
A scalar. Estimated height (m) given a diameter without bark.
}
\description{
Functional equivalent to \code{\link[TapeR]{E_HDx_HmDm_HT.f}},
finding the height of a given diameter *without* bark, i.e. double bark
thickness needs to be added on top of given diameter to find appropriate
height.
}
\details{
finds height of given diameter via \code{uniroot}.
}
\section{Functions}{
\itemize{
\item \code{HxoR_root.f()}: function to be searched

}}
\examples{
tmp <- tprTrees()
spp <- spp(tmp)
Hm <- Hm(tmp)
Dm <- Dm(tmp)
H <- Ht(tmp)
data("SKPar")
sppSK <- BaMap(spp, 1) # tree species for taper curve
## diameter in 5m height
TapeR::E_DHx_HmDm_HT.f(c(5, 10), Hm, Dm, mHt=H, sHt = 0, par.lme = SKPar[[sppSK]])$DHx
(D5m <- TapeR::E_DHx_HmDm_HT.f(c(5, 10), Hm, Dm, mHt=H, sHt = 0, par.lme = SKPar[[sppSK]])$DHx)
## bark thickness of diameter in 5m height
(RiD5m <- bark(c(1,1), Dm = D5m, relH = c(5, 10)/H))
## find height of diameter without bark, which should be 5m
d5mub <- D5m - RiD5m
E_HDxoR_HmDm_Ht.f(DxoR = d5mub, Hm = Hm, Dm = Dm, mHt = H,
                  sHt = 0, par.lme = SKPar[[sppSK]])
}
