% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bark.r
\name{bark}
\alias{bark}
\title{Double Bark Thickness}
\usage{
bark(Ba, Dm, relH)
}
\arguments{
\item{Ba}{tree species according to BDAT, cf. \code{\link{tprSpeciesCode}}}

\item{Dm}{diameter for which double bark thickness is requested}

\item{relH}{relative height of Dm inside stem}
}
\value{
double bark thickness [cm]
}
\description{
Function returns double bark thickness according to
Altherr et al. 1974/75/76/78/79
}
\details{
Function re-implemented according to
Subroutine RINDE(Hhrel,Kw,Ri,Hsga,Zo), BDAT-fortran Code line 5691ff.
No Functions for (historic) Heilbronner Sortierung implemented.

NB: to avoid negative double bark thickness, such values are constraint to
zero. Additionally, diameter after bark reduction might not be smaller than
zero, hence double bark thickness is reduce to \code{Dm}.
}
\examples{
bark(1, 30, .1)
bark(11, 4, .1) # zero instead of -0.2497
}
\references{
Altherr, E., P. Unfried, J. Hradetzky and V. Hradetzky (1974). Statistische
Rindenbeziehungen als Hilfsmittel zur Ausformung und Aufmessung unentrindeten
Stammholzes. Kiefer, Buche, Hainbuche, Esche und Roterle. Freiburg i. Br.,
Forstl. Versuchs- u. Forschungsanst. Baden-Württenberg.

Altherr, E., P. Unfried, J. Hradetzky and V. Hradetzky (1975). Statistische
Rindenbeziehungen als Hilfsmittel zur Ausformung und Aufmessung unentrindeten
Stammholzes. Europäische Lärche, Japanische Lärche, Schwarzkiefer, Stieleiche,
Traubeneiche, Roteiche, Bergahorn und Linde. Freiburg i. Br., Forstl.
Versuchs- u. Forschungsanst. Baden-Württenberg.

Altherr, E., P. Unfried, J. Hradetzky and V. Hradetzky (1976). Statistische
Rindenbeziehungen als Hilfsmittel zur Ausformung und Aufmessung unentrindeten
Stammholzes. Weymouthskiefer, Robinie, Bergulme, Birke, Marilandica-Pappel
und Robusta-Pappel. Freiburg i. Br., Forstl. Versuchs- u. Forschungsanst.
Baden-Württenberg.

Altherr, E., P. Unfried, J. Hradetzky and V. Hradetzky (1978). Statistische
Rindenbeziehungen als Hilfsmittel zur Ausformung und Aufmessung unentrindeten
Stammholzes. Fichte, Tanne, Douglasie und Sitka-Fichte. Freiburg i. Br.,
Forstl. Versuchs- u. Forschungsanst. Baden-Württenberg.

Altherr, E., P. Unfried, J. Hradetzky and V. Hradetzky (1979). Statistische
Rindenbeziehungen als Hilfsmittel zur Ausformung und Aufmessung unentrindeten
Stammholzes. Neupotz-Pappel, Regenerata-Pappel, Kirsche, Spitzahorn, Feldahorn,
Aspe, Weide, Flatterulme, Tulpenbaum u. Elsbeere. Freiburg i. Br., Forstl.
Versuchs- u. Forschungsanst. Baden-Württenberg.
}
