## ----global_options, include=FALSE---------------------------------------
knitr::opts_chunk$set(fig.width=6, 
                      fig.height=4, fig.path='Figs/',
                      echo=TRUE, warning=FALSE, message=FALSE)

## ------------------------------------------------------------------------
library(TeachBayes)

## ------------------------------------------------------------------------
prior <- testing_prior(.05, .95, 10,
                       uniform=TRUE)

## ------------------------------------------------------------------------
draw_two_p(prior)

## ------------------------------------------------------------------------
(diff_dist <- two_p_summarize(prior))
prob_plot(diff_dist)

## ------------------------------------------------------------------------
y1n1 <- c(10, 20)
y2n2 <- c(8, 24)

## ------------------------------------------------------------------------
post <- two_p_update(prior, y1n1, y2n2)

## ------------------------------------------------------------------------
draw_two_p(post)

## ------------------------------------------------------------------------
prob_plot(two_p_summarize(post))

## ------------------------------------------------------------------------
prior <- testing_prior(.05, .95, 10, pequal=0.5)

## ------------------------------------------------------------------------
draw_two_p(prior)

## ------------------------------------------------------------------------
prob_plot(two_p_summarize(prior))

## ------------------------------------------------------------------------
y1n1 <- c(10, 20)
y2n2 <- c(8, 24)

## ------------------------------------------------------------------------
post <- two_p_update(prior, y1n1, y2n2)

## ------------------------------------------------------------------------
draw_two_p(post)

## ------------------------------------------------------------------------
prob_plot(two_p_summarize(post))

