# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Matrix Trace
#'
#' Calculates the trace of a matrix \eqn{A}.
#'
#' @param A Numeric matrix.
#' @return Scalar.
tr <- function(A) {
    .Call('_Temporal_tr', PACKAGE = 'Temporal', A)
}

#' Matrix Matrix Product
#'
#' Calculates the product \eqn{AB}. 
#'
#' @param A Numeric matrix.
#' @param B Numeric matrix.
#' @return Numeric matrix. 
MMP <- function(A, B) {
    .Call('_Temporal_MMP', PACKAGE = 'Temporal', A, B)
}

#' Matrix Inner Product
#'
#' Calculates the product \eqn{A'B}.
#'
#' @param A Numeric matrix.
#' @param B Numeric matrix.
#' @return Numeric matrix. 
matIP <- function(A, B) {
    .Call('_Temporal_matIP', PACKAGE = 'Temporal', A, B)
}

#' Matrix Inverse
#' 
#' Calcualtes \eqn{A^{-1}}.
#'
#' @param A Numeric matrix.
#' @return Numeric matrix. 
matInv <- function(A) {
    .Call('_Temporal_matInv', PACKAGE = 'Temporal', A)
}

#' Matrix Determinant
#'
#' Calculates the determinant of \eqn{A}.
#'
#' @param A Numeric matrix.
#' @return Scalar. 
det <- function(A) {
    .Call('_Temporal_det', PACKAGE = 'Temporal', A)
}

#' Fast Outer Product
#' 
#' Calculates the outer product \eqn{XY'}.
#' 
#' @param X Numeric matrix.
#' @param Y Numeric matrix.
#' @return Numeric matrix.
matOP <- function(X, Y) {
    .Call('_Temporal_matOP', PACKAGE = 'Temporal', X, Y)
}

#' Quadratic Form
#' 
#' Calculates the quadratic form \eqn{X'AX}.
#' 
#' @param X Numeric matrix.
#' @param A Numeric matrix.
#' @return Numeric matrix. 
matQF <- function(X, A) {
    .Call('_Temporal_matQF', PACKAGE = 'Temporal', X, A)
}

#' Schur complement
#'
#' Calculates the efficient information \eqn{I_{bb}-I_{ba}I_{aa}^{-1}I_{ab}}. 
#'
#' @param Ibb Information of target parameter
#' @param Iaa Information of nuisance parameter
#' @param Iba Cross information between target and nuisance parameters
#' @return Numeric matrix. 
SchurC <- function(Ibb, Iaa, Iba) {
    .Call('_Temporal_SchurC', PACKAGE = 'Temporal', Ibb, Iaa, Iba)
}

