% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tLU.R
\name{tLU}
\alias{tLU}
\title{LU decomposition of a 3D tensor}
\usage{
tLU(tnsr, tform)
}
\arguments{
\item{tnsr, }{a 3-mode tensor S3 class object}

\item{tform, }{Any discrete transform.

fft: Fast Fourier Transform

dwt: Discrete Wavelet Transform (Haar Wavelet)

dct: Discrete Cosine transform

dst: Discrete Sine transform

dht: Discrete Hadley transform

dwht: Discrete Walsh-Hadamard transform}
}
\value{
L, The lower triangular tensor object

U, The upper triangular tensor object
a \href{/library/rTensor2/help/Tensor3-class}{Tensor3-class} object
}
\description{
Decomposes a 3 model tensor into a lower triangular tensor and an upper triangular tensor.
}
\examples{
T <- t_rand(modes=c(2,2,4))
tLU(T,"dst")
}
\references{
M. E. Kilmer, C. D. Martin, and L. Perrone, “A third-order generalization of the matrix svd as a product of third-order tensors,” Tufts University, Department of Computer Science, Tech. Rep. TR-2008-4, 2008

K. Braman, "Third-order tensors as linear operators on a space of matrices", Linear Algebra and its Applications, vol. 433, no. 7, pp. 1241-1253, 2010.
}
\author{
Kyle Caudle

Randy Hoover

Jackson Cates

Everett Sandbo
}
