% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{holdridgeClasses}
\alias{holdridgeClasses}
\alias{holdridgeLifeZones}
\alias{holdridgeLifeZonesUp}
\alias{holdridgeClassesUp}
\title{Names of the 38 classes defined with the Holdridge system}
\format{
An object of class \code{character} of length 38.

An object of class \code{character} of length 33.

An object of class \code{character} of length 33.

An object of class \code{character} of length 38.
}
\source{
Holdridge (1947),
"Determination of world plant formations from simple climatic data",
\emph{Science} 105:367–368. \doi{10.1126/science.105.2727.367}

Holdridge (1967),
\href{https://reddcr.go.cr/sites/default/files/centro-de-documentacion/holdridge_1966_-_life_zone_ecology.pdf}{\emph{Life zone ecology}}.
Tropical Science Center, San José

Leemans, R. (1990),
"Possible change in natural vegetation patterns due to a global warming",
\emph{International Institute for Applied Systems Analysis} Working paper
WP-90-08.
\url{https://pure.iiasa.ac.at/id/eprint/3443/1/WP-90-008.pdf}
}
\usage{
holdridgeClasses

holdridgeLifeZones

holdridgeLifeZonesUp

holdridgeClassesUp
}
\description{
\code{holdridgeClasses} is a character vector naming, from left to right,
top to bottom, the 38 classes defined by the International Institute for
Applied Systems Analysis (IIASA).
}
\details{
\code{holdridgeLifeZones} is a character vector naming, from left to right,
top to bottom, the 38 cells of the Holdridge classification plot.

\code{holdridgeClassesUp} and \code{holdridgeLifeZonesUp} replace spaces with new
lines, for more legible plotting with \code{\link[=HoldridgeHexagons]{HoldridgeHexagons()}}.
}
\seealso{
Other Holdridge plotting functions: 
\code{\link{AddToHoldridge}()},
\code{\link{HoldridgeHypsometricCol}()},
\code{\link{HoldridgePlot}()},
\code{\link{holdridge}}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{Holdridge plotting functions}
\keyword{datasets}
