% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clsModelContainer.R
\docType{class}
\name{PROB_BASEVAR-class}
\alias{PROB_BASEVAR-class}
\alias{PROB_BASEVAR}
\title{Object to store the distribution model for base vars}
\description{
Object to store the distribution model for base vars...
}
\section{Fields}{

\describe{
\item{\code{Id}}{Place in vector of objective functional expression function(x){x[id]}}

\item{\code{Name}}{name like f_ck, used in the limit state function as input name}

\item{\code{Description}}{Used for better understanding of vars}

\item{\code{DistributionType}}{Distributiontypes like "norm", "lnorm", "weibull", "t", "gamma", etc...}

\item{\code{Package}}{The name of the package the Distribution should be taken from (e.g. "evd")}

\item{\code{Mean}}{The Mean Value of this Basisvariable}

\item{\code{Sd}}{The SD Value of this Basisvariable}

\item{\code{Cov}}{The Cov fitting to Mean and Sd.}

\item{\code{x0}}{Shiftingparameter}

\item{\code{DistributionParameters}}{Inputparameters of the distribution, may be calculated internally}
}}

\section{Methods}{

\describe{
\item{\code{prepare()}}{Runs the transformations (from mean, sd -> parameters or the other way round) and checks COV, MEAN and SD fitting together.
If distribution is not available an error ll be thrown.}
}}

\examples{
var1 <- PROB_BASEVAR(Name="var1", Description="yield strength",
DistributionType="norm", Mean=500, Sd=60)
var1$prepare()

var2 <- PROB_BASEVAR(Name="var2", Description="Load",
DistributionType="gumbel",Package="evd",Mean=40, Sd=3)
var2$prepare()

}
\author{
(C) 2021 - K. Nille-Hauf, T. Feiri, M. Ricker - Hochschule Biberach, Institut fuer Konstruktiven Ingenieurbau
}
