% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clsModelContainer.R
\docType{class}
\name{SYS_PROB-class}
\alias{SYS_PROB-class}
\alias{SYS_PROB}
\title{System Probabliation Solution Object}
\description{
Object to create probabilistic problems. Including Equation, List of Basisvariable, and Solutionmachines
}
\section{Fields}{

\describe{
\item{\code{sys_input}}{List of SYS_LSFs}

\item{\code{sys_type}}{determining serial or parallel system, not implemented yet}

\item{\code{probMachines}}{list of PROB_MACHINES}

\item{\code{res_single}}{grab results after .runMachines()}
}}

\section{Methods}{

\describe{
\item{\code{calculateSystemProbability(calcType = "simpleBounds", params = list())}}{Calculates the system probablity if more than one lsf is given and a system_type (serial or parallel) is set.
If calcType is empty (or simpleBounds), only simpleBounds are applied to further calculation of single soultions.
If calcType is MCIS, than a Monte Carlo Importance Sampling Method is used (only for parallel systems available).
If calcType is MCC, than a Crude Monte Carlo Simulation is used.
If calcType is MCSUS, than the Subset Sampling Algorithm ll be used.
You can pass arguments to methods via the params field, while the argument has to be a named list (for example check the vignette).}

\item{\code{plotGraph(plotType = "sim.performance")}}{not finally implemented. Do not use.}

\item{\code{printResults(path = "")}}{TesiproV can create a report file with all the necessary data for you. If you provide a path (or filename, without ending) it will store
the data there, otherwise it will report to the console. Set the path via setwd() or check it via getwd().}

\item{\code{runMachines()}}{Starts solving all given problems (sys_input) with all given algorithms (probMachines). After that one can access via $res...1}

\item{\code{saveProject(level, filename = "tesiprov_project")}}{You can save your calculation project with saveProject().
There are four different levels of detail to save
1st Level: Only the beta values
2nd Level: The result Objects of single or systemcalculation
3th Level: All The Probablity System Object, including limit state functions, machines and solutions
4th Level: An image of your entire workspace}
}}

\examples{
ps <- SYS_PROB(
sys_input=list(SYS_LSF(),SYS_LSF()),
probMachines=list(PROB_MACHINE()),
sys_type="serial")
\dontrun{
ps$runMachines()
ps$beta_sys
ps$res_sys
ps$printResults("example_1")
ps$saveProject(4,"example_1")
}

}
\author{
(C) 2021 - K. Nille-Hauf, T. Feiri, M. Ricker - Hochschule Biberach, Institut fuer Konstruktiven Ingenieurbau
}
