% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApplyFwer.R
\name{ApplyFwerCor}
\alias{ApplyFwerCor}
\title{Applies multiple testing procedures controlling (asymptotically) the FWER
for tests on a correlation matrix.}
\usage{
ApplyFwerCor(
  data,
  alpha = NULL,
  stat_test = "empirical",
  method = "Sidak",
  Nboot = 1000,
  stepdown = TRUE,
  vect = FALSE,
  logical = stepdown,
  arr.ind = FALSE
)
}
\arguments{
\item{data}{matrix of observations}

\item{alpha}{level of multiple testing (used if logical=TRUE)}

\item{stat_test}{\describe{
  \item{'empirical'}{\eqn{\sqrt{n}*abs(corr)}}
  \item{'fisher'}{   \eqn{\sqrt{n-3}*1/2*\log( (1+corr)/(1-corr) )}}
  \item{'student'}{  \eqn{\sqrt{n-2}*abs(corr)/\sqrt(1-corr^2)}}
  \item{'2nd.order'}{ \eqn{\sqrt{n}*mean(Y)/sd(Y)} with \eqn{Y=(X_i-mean(X_i))(X_j-mean(X_j))}}
}}

\item{method}{choice between 'Bonferroni', 'Sidak', 'BootRW', 'MaxTinfty'}

\item{Nboot}{number of iterations for Monte-Carlo of bootstrap quantile evaluation}

\item{stepdown}{logical, if TRUE a stepdown procedure is applied}

\item{vect}{if TRUE returns a vector of adjusted p-values, corresponding to \code{vectorize(cor(data))};
if FALSE, returns an array containing the adjusted p-values for each entry of the correlation matrix}

\item{logical}{if TRUE, returns either a vector or a matrix where each element is equal to TRUE if the corresponding null hypothesis is rejected, and to FALSE if it is not rejected
if \code{stepdown=TRUE} and \code{logical=FALSE}, returns a list of successive p-values.}

\item{arr.ind}{if TRUE, returns the indexes of the significant correlations, with repspect to level alpha}
}
\value{
Returns either \itemize{\item{the adjusted p-values, as a vector or a matrix, depending on \code{vect}} \item{logicals indicating if the corresponding correlation is significant if \code{logical=TRUE}, as a vector or a matrix depending on \code{vect},} \item{an array containing indexes \eqn{\lbrace(i,j),\,i<j\rbrace} for which correlation between variables \eqn{i} and \eqn{j} is significant, if \code{arr.ind=TRUE}.}}
}
\description{
Applies multiple testing procedures controlling (asymptotically) the FWER
for tests on a correlation matrix.
Methods are described in Chapter 5 of \cite{Roux (2018)}.
}
\examples{
n <- 100
p <- 10
corr_theo <- diag(1,p)
corr_theo[1,3] <- 0.5
corr_theo[3,1] <- 0.5
data <- MASS::mvrnorm(n,rep(0,p),corr_theo)
# adjusted p-values
(res <- ApplyFwerCor(data,stat_test='empirical',method='Bonferroni',stepdown=FALSE))
# significant correlations, level alpha:
alpha <- 0.05
whichCor(res<alpha)
}
\references{
Bonferroni, C. E. (1935). Il calcolo delle assicurazioni su gruppi di teste. Studi in onore del professore salvatore ortu carboni, 13-60.

Drton, M., & Perlman, M. D. (2007). Multiple testing and error control in Gaussian graphical model selection. Statistical Science, 22(3), 430-449.

Romano, J. P., & Wolf, M. (2005). Exact and approximate stepdown methods for multiple hypothesis testing. Journal of the American Statistical Association, 100(469), 94-108.

Roux, M. (2018). Graph inference by multiple testing with application to Neuroimaging, Ph.D., Université Grenoble Alpes, France, https://tel.archives-ouvertes.fr/tel-01971574v1.

Šidák, Z. (1967). Rectangular confidence regions for the means of multivariate normal distributions. Journal of the American Statistical Association, 62(318), 626-633.
}
\seealso{
ApplyFwerCor_SD, ApplyFdrCor

BonferroniCor, SidakCor, BootRWCor, maxTinftyCor

BonferroniCor_SD, SidakCor_SD, BootRWCor_SD, maxTinftyCor_SD
}
