% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_gen.R
\name{raw_gen}
\alias{raw_gen}
\title{Raw Data Generation By Log-normal Or Truncated Distribution}
\usage{
raw_gen(
  x,
  Parms = 1,
  Pop = 2,
  R.res = NULL,
  dist = c("truncated", "log"),
  lower = -Inf,
  upper = Inf,
  format = c("wide", "long"),
  complete_cases = FALSE
)
}
\arguments{
\item{x}{Tibble/Data frame or list containing summary statistics for
multiple parameters measured in both sexes in two or more populations.}

\item{Parms}{Number of the column containing names of measured parameters,
Default: 1}

\item{Pop}{Number of the column containing populations' names, Default: 2}

\item{R.res}{Pooled within correlational matrix, Default: NULL}

\item{dist}{univariate distribution used for data generation either \code{log}
for log normal or \code{truncated} for truncated, Default: 'truncated'}

\item{lower}{vector of lower bounds, Default: -Inf}

\item{upper}{vector of upper bounds, Default: Inf}

\item{format}{form of the resultant tibble either 'long' or 'wide',
Default: 'wide'}

\item{complete_cases}{Logical; if TRUE rows with missing values will be
removed, Default: FALSE}
}
\value{
tibble of raw data
}
\description{
Generates raw data from summary statistics using
uni/multivariate log/truncated normal distribution
}
\details{
If data generation is desired using multivariate distribution data
is entered in the form of a list of summary statistics and pooled within
correlational matrix as in \link{baboon.parms_list}, or the summary statistics
are entered separately in the form of a data frame/tibble as in
\link{baboon.parms_df} with a separate correlational matrix as in \link{R}. If data
frame/tibble is entered without a correlational matrix, data generation is
carried out using univariate distribution. N.B: Transformation of raw
summary data to logged data is only possible for univariate distribution
and if multivariate log normal distribution is desired logged values should
be entered directly with \code{dist} set to \code{truncated}.
}
\examples{
\donttest{
# Data generation using univariate distribution
library(TestDimorph)
raw_gen(baboon.parms_df)
# Data generation using multivariate distribution
library(TestDimorph)
raw_gen(baboon.parms_list)
}
}
