% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmHetero.R
\name{lmHetero}
\alias{lmHetero}
\title{Function: Multiplicately weighted regression model}
\source{
The maximum likelihood estimation procedure for multiplicately
weighted regression is given in Greene W. H. (2000). Econometric Analysis.
4th edition. Upper Saddle River: Prentice Hall. pp 516-521
(Note: page numbers will differ for other editions)
}
\usage{
lmHetero(
  formula,
  hetero = ~1,
  data,
  subset,
  na.action,
  contrasts = NULL,
  iter = FALSE,
  ...
)
}
\arguments{
\item{formula}{Formula object (perhaps, multiple parts formula
 \code{y~x1+x2+...| log(z1)+log(z2)+...}) linking the dependent
variable to its set of associated independent variables x and a second
expression separated by \code{|} modelling the local variances with the
variables z. The formula \code{y~x1+x2+...} assumes homoscedasticity.
\strong{Important:} the weights variables z must be entered in
their log-transformed form! This is the preferred specification of the function call.}

\item{hetero}{Optional formula specification without "\code{| log(z1)+log(z2)+...}":
A second parameter modeling the heteroscedasticity with a right-handed formula
by a set of variables z. That is, "\code{hetero=~log(z1)+log(z2)+...}".
Omitting the second parameter assumes "\code{hetero=~1}". This is only included
for backward compatibility).}

\item{data}{An optional data frame containing the variables in the model.
By default the variables are taken from the environment of the formula.}

\item{subset}{An optional vector specifying a subset of observations to
be used in fitting the model.}

\item{na.action}{A function that indicates what should happen when the data
contain \code{NA}s. The default is set by the "\code{na.action}" option}

\item{contrasts}{An optional list. See the "\code{contrasts.arg}" of
\code{\link{model.matrix.default}}.}

\item{iter}{Logical indicating whether the interation history should be
displayed. The default setting if "\code{FALSE}".}

\item{...}{Currently not in use.}
}
\value{
a list with 10 elements:
\item{CALL}{function call}
\item{sigma2}{global variance estimate \eqn{exp(gamma_0)}}
\item{gamma}{vector of estimated gamma coefficients}
\item{namesGamma}{vector of variable names expressed by Z}
\item{beta}{vector of estimated weight adjusted regression parameters}
\item{weights}{vector of weights \eqn{1/\sigma^2_i} estimates for each
observation. It can be used in the call \code{lm(..., weights=weights)}
to adjust for heteroscedasticity}
\item{covBeta}{covariance matrix of the estimated regression coefficients}
\item{covGamma}{covariance matrix of the estimated gamma coefficients}
\item{logLikeH1}{log-likelihood of the heteroscedastic adjusted regression
model}
\item{logLikeH0}{log-likelihood of the unadjusted regression model}
}
\description{
\code{lmHetero} accounts for heteroscedasticity in regression models
}
\details{
This function estimates the parameters of a regression model whose normally
distributed disturbances have a variance that multiplicatively depends on a
set of strictly positive weights variables. That is,

\deqn{\sigma^2_i = \exp(\gamma_0 + \gamma_1 \cdot \log(z_{i1}) + ...)}

The weights variables z must be entered in their logarithmic forms. The
paramater \eqn{\exp(\gamma_0)} expresses the global variance.
}
\examples{
library(sp)
data(tractShp)
validTractShp <- tractShp[!is.na(tractShp$BUYPOW), ]         # Remove 2 tracts with NA's
## Population at risk
totPop <- validTractShp$MALE+validTractShp$FEMALE

## H0 model (homoscedasticity)
mod.lm <- mod.lmH <- lmHetero(PERCAPINC~PCTNOHINS+PCTMINOR+PCTUNIVDEG+PCTWHITE,
                              data=validTractShp)
summary(mod.lm)

## Preferred heteroscedasticiy function call
mod.lmH <- lmHetero(PERCAPINC~PCTNOHINS+PCTMINOR+PCTUNIVDEG+PCTWHITE|log(totPop),
                    data=validTractShp)
summary(mod.lmH)

## Alternative equivalent heteroscedasticiy function call
mod.lmH <- lmHetero(PERCAPINC~PCTNOHINS+PCTMINOR+PCTUNIVDEG+PCTWHITE, hetero=~log(totPop),
                    data=validTractShp)
summary(mod.lmH)

## Use estimated weights as input for weighted lm-model.
## This also to perform further model diagnostics.
mod.lmW <- lm(PERCAPINC~PCTNOHINS+PCTMINOR+PCTUNIVDEG+PCTWHITE, weights=mod.lmH$weights,
              data=validTractShp)
summary(mod.lmW)
hist(weighted.residuals(mod.lmW))

}
\author{
Michael Tiefelsdorf (\email{tiefelsdorf@utdallas.edu}) & Yongwan Chun
}
