% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{list_plots}
\alias{list_plots}
\title{List the plot identifiers of all the plots in a given multiqc report}
\usage{
list_plots(path)
}
\arguments{
\item{path}{The file path to the multiqc report. This should be a length 1
character vector}
}
\value{
A data frame containing \eqn{n} rows, where \eqn{n} is the number
of plots in the report you have provided, and two columns:
\describe{
\item{id}{The identifier for the plot. This is the one you should use as a name in \code{plot_opts}.}
\item{name}{The plot title. This is likely what you see in the multiqc report when you open it with your browser.}
}
}
\description{
List the plot identifiers of all the plots in a given multiqc report
}
\details{
The main use for this function is finding the plot identifiers
that you will then pass into the \code{plots} argument of the \code{\link[=load_multiqc]{load_multiqc()}}
function.
Refer to the section on "Extracting Plot Data" in the main vignette for more information.
}
\examples{
# Ignore this, choose your own filepath as the `filepath` variable
filepath <- system.file("extdata", "HG00096/multiqc_data.json", package = "TidyMultiqc")
# This is the actual invocation
list_plots(filepath)
}
