\name{PlotDRT}
\alias{PlotDRT}
\alias{PLOTDRT}
\title{List taxa names present in the BEAST input file}
\description{
    Once analyzed with BEAST, the PlotDRT function allows comparing the parameter estimates 
	obtained with the original vs. the randomized datasets. This function requires uploading, 
	reading and analysing the "Log" files generated by BEAST. A Log file contains a row for
	each MCMC sampling and a column for each estimated parameter. When considered as frequency
	distributions, this file provides an estimate of the marginal posterior probability distribution
	for each parameter. The function "PlotDRT" enable a graphical comparison of the parameter
	estimates obtained with the original vs. the date-randomized datasets
	(whatever the shuffling procedure considered).
}
\usage{
PlotDRT(name, reps, burnin = 0.1)
}
\arguments{
    \item{name}{
        The name of the original Log file (excluding the .log extension) to upload and compute the real
		parameter estimates on. The name of the Log files computed from the date-randomized datasets
		should look like "name.Rep[i].log"
    }
	\item{reps}{
		The number date-randomized log files
	}
	\item{burnin}{
		the fraction of the first MCMC sampling to exclude from the Log files when computing the parameter
		estimates distribution (default = 0.1, which means 10%)
	}
}
\details{
    The function works only after all BEAST runs are completed
}
\value{
    The function produce a two plots; one in normal scale, one in log scale.
}
\references{
	Rieux A & Khatchikian, C. Unpublished.
	Drummond AJ, Suchard MA, Xie D & Rambaut A (2012) Bayesian phylogenetics with BEAUti and the BEAST 1.7.
	Molecular Biology And Evolution 29: 1969-1973.
}
\examples{
\dontrun{
	# example create with example file
	PlotDRT("Flu_BEAST_1.8", reps = 20, burnin = 0.1)
	# produce DRT plot 
}
}
\keyword{BEAST Software}
\keyword{phylogenetics}
