% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NeighborOmega.R
\name{NeighborOmega}
\alias{NeighborOmega}
\title{Precision Matrix of Nearest-Neighbor Graph}
\usage{
NeighborOmega(p, sd = 1, knn = 4, norm.type = 2)
}
\arguments{
\item{p}{dimension of generated precision matrix.}

\item{sd}{seed for random number generation. Default is 1.}

\item{knn}{sparsity of precision matrix, i.e., matrix is generated from a \code{knn} nearest-neighbor graph. \code{knn} should be less than \code{p}. Default is 4.}

\item{norm.type}{normalization methods of generated precision matrix, i.e., \eqn{\Omega_{11} = 1}{\Omega_{11}=1} 
if norm.type = 1 and \eqn{\|\Omega\|_{F}=1}{||\Omega||_F =1 } if norm.type = 2. Default value is 2.}
}
\value{
A precision matrix generated from the \code{knn} nearest-neighor graph.
}
\description{
Generate precision matrix of nearest-neighbor network following the set-up in \href{http://paperity.org/p/38773767/gradient-directed-regularization-for-sparse-gaussian-concentration-graphs-with}{Li and Gui (2006)}
and \href{http://www.jmlr.org/papers/volume16/lee15a/lee15a.pdf}{Lee and Liu (2006)}.
}
\details{
For a \code{knn} nearest-neighbor graph, this function first randomly picks p points from a 
unit square and computes all pairwise distances among the points. Then it searches for the knn nearest-neighbors
of each point and a pair of symmetric entries in the precision matrix that has a random chosen value from \eqn{[-1, -0.5] \cup [0.5, 1]}{[-1, -0.5] U [0.5, 1]}. Finally, to 
ensure positive definite property, it normalizes the matrix as \eqn{\Omega <- \Omega + (\lambda (\Omega) + 0.2 ) 1_p}{\Omega <- \Omega + (\lambda (\Omega)+0.2) 1_p} where 
\eqn{\lambda (\cdot )}{\lambda (.)} refers to the samllest eigenvalue.
}
\examples{

m.vec = c(5,5,5)  # dimensionality of a tensor 
n = 5   # sample size 
knn=4 # sparsity 

Omega.true.list = list()

for ( k in 1:length(m.vec)){
  Omega.true.list[[k]] = NeighborOmega(m.vec[k],knn=4, sd=k*100,norm.type=2)
}
Omega.true.list  # a list of length 3 contains precision matrices from 4-nearnest neighbor graph

}
\author{
Will Wei Sun, Zhaoran Wang, Xiang Lyu, Han Liu, Guang Cheng.
}
\seealso{
\code{\link{ChainOmega}}
}

