% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_extractors.R
\name{str_extract_fmt_group}
\alias{str_extract_fmt_group}
\alias{str_extract_num}
\title{Extract format group strings or numbers}
\usage{
str_extract_fmt_group(string, format_group)

str_extract_num(string, format_group)
}
\arguments{
\item{string}{A string of number results from which to extract format groups}

\item{format_group}{An integer representing format group that should be
extracted}
}
\value{
A character vector
}
\description{
These functions allow you to extract segments of information from within a
result string by targetting specific format groups. \code{str_extract_fmt_group()}
allows you to pull out the individual format group string, while
\code{str_extract_num()} allows you to pull out that specific numeric result.
}
\details{
Format groups refer to individual segments of a string. For example, given
the string ' 5 (34.4\%) [9]', there are three separate format groups, which
are ' 5', '(34.4\%)', and '[9]'.
}
\examples{

string <- c(" 0  (0.0\%)", " 8  (9.3\%)", "78 (90.7\%)")

str_extract_fmt_group(string, 2)

str_extract_num(string, 2)

}
\concept{String extractors}
