% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HashTable.R
\docType{class}
\name{HashTable-class}
\alias{HashTable}
\title{Hashtable Class}
\arguments{
\item{keys}{A vector of keys}

\item{values}{A vector of values mapping to the keys}

\item{keys_type}{The type of the keys}

\item{values_type}{The type of the values}
}
\value{
An object of type HashTable
}
\description{
Creates a hashtable-like object so as to represent data with a key structure (for example addon tables, rating-based factors etc).
Also, it includes methods for populating the object via a .csv file and finding a value based on a specific key on an interval of keys
For examples of the format of the CSVs files, please view RatingsMapping.csv or AddonTable.csv on the extdata folder in the installation folder of the library
}

\examples{

## loading a ratings' mapping matrix from the extdata folder
rating_table = HashTable('RatingsMapping.csv',"character","numeric")
reg_weight =rating_table$FindValue("AAA")

}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
