% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posteriorPredictive.R
\name{posteriorPredictive}
\alias{posteriorPredictive}
\title{Get Posterior Predictive Samples}
\usage{
posteriorPredictive(fittedModel, M = 100, expected = FALSE, nCPU = 4)
}
\arguments{
\item{fittedModel}{fitted latent-trait or beta MPT model (\code{\link{traitMPT}}, \code{\link{betaMPT}})}

\item{M}{number of posterior predictive samples. As a maximum, the number of posterior samples in \code{fittedModel} is used.}

\item{expected}{if \code{TRUE}, the expected frequencies per person are returned (without additional sampling from a multinomial distribution)}

\item{nCPU}{number of CPUs used for parallel sampling. For large models and many participants, this requires a lot of memory.}
}
\value{
a list of \code{M} matrices with individual frequencies (rows=participants, columns=MPT categories). For \code{M=1}, a single matrix is returned.
}
\description{
Draw frequencies based on posterior distribution of individual estimates.
}
\examples{
\dontrun{
# add posterior predictive samples that are reused in ?plotFit
fittedModel$postpred$freq.pred <-
     posteriorPredictive(fittedModel, M=1000)
}
}

