% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_distance_rf.R
\encoding{UTF-8}
\name{Robinson-Foulds}
\alias{Robinson-Foulds}
\alias{InfoRobinsonFoulds}
\alias{RobinsonFouldsInfo}
\alias{InfoRobinsonFouldsSplits}
\alias{RobinsonFoulds}
\alias{RobinsonFouldsMatching}
\alias{RobinsonFouldsSplits}
\title{Robinson–Foulds distances, with adjustments for phylogenetic information
content}
\usage{
InfoRobinsonFoulds(
  tree1,
  tree2 = NULL,
  similarity = FALSE,
  normalize = FALSE,
  reportMatching = FALSE
)

InfoRobinsonFouldsSplits(
  splits1,
  splits2,
  nTip = attr(splits1, "nTip"),
  reportMatching = FALSE
)

RobinsonFoulds(
  tree1,
  tree2 = NULL,
  similarity = FALSE,
  normalize = FALSE,
  reportMatching = FALSE
)

RobinsonFouldsMatching(
  tree1,
  tree2,
  similarity = FALSE,
  normalize = FALSE,
  ...
)

RobinsonFouldsSplits(
  splits1,
  splits2,
  nTip = attr(splits1, "nTip"),
  reportMatching = FALSE
)
}
\arguments{
\item{tree1, tree2}{Trees of class \code{phylo}, with leaves labelled identically,
or lists of such trees to undergo pairwise comparison.  Where implemented,
\code{tree2 = NULL} will compute distances between each pair of trees in the list
\code{tree1} using a fast algorithm based on Day (1985).}

\item{similarity}{Logical specifying whether to report the result as a tree
similarity, rather than a difference.}

\item{normalize}{If a numeric value is provided, this will be used as a
maximum value against which to rescale results.
If \code{TRUE}, results will be rescaled against a maximum value calculated from
the specified tree sizes and topology, as specified in the 'Normalization'
section below.
If \code{FALSE}, results will not be rescaled.}

\item{reportMatching}{Logical specifying whether to return the clade
matchings as an attribute of the score.}

\item{splits1, splits2}{Logical matrices where each row corresponds to a leaf,
either listed in the same order or bearing identical names (in any sequence),
and each column corresponds to a split, such that each leaf is identified as
a member of the ingroup (\code{TRUE}) or outgroup (\code{FALSE}) of the respective
split.}

\item{nTip}{(Optional) Integer specifying the number of leaves in each split.}

\item{\dots}{Not used.}
}
\value{
\code{RobinsonFoulds()} and \code{InfoRobinsonFoulds()} return an array of numerics providing the
distances between each  pair of trees in \code{tree1} and \code{tree2},
or \code{splits1} and \code{splits2}.
}
\description{
Calculate the Robinson–Foulds distance
\insertCite{Robinson1981}{TreeDist}, or
the equivalent similarity measure, with options to
(i) annotate matched splits;
(ii) weight splits according to their phylogenetic information content
\insertCite{SmithDist}{TreeDist}.
}
\details{
Note that if \code{reportMatching = TRUE}, the \code{pairScores} attribute returns
a logical matrix specifying whether each pair of splits is identical.

\code{InfoRobinsonFoulds()} calculates the tree similarity or distance by summing
the phylogenetic information content of all splits that are (or are not)
identical in both trees.  Consequently, splits that are more likely
to be identical by chance alone make a smaller contribution to overall
tree distance, because their similarity is less remarkable.

Rapid comparison between multiple pairs of trees employs the Day
\insertCite{Day1985;textual}{TreeDist} linear-time algorithm.
}
\section{Functions}{
\itemize{
\item \code{RobinsonFouldsMatching()}: Matched splits, intended for use with
\code{\link[=VisualizeMatching]{VisualizeMatching()}}.

}}
\section{Normalization}{

\itemize{
\item \code{RobinsonFoulds()} is normalized against the total number of splits that
are present.
\item \code{InfoRobinsonFoulds()} is normalized against the sum of the phylogenetic
information of all splits in both trees, treated independently.
}
}

\examples{
 # For BalancedTree, PectinateTree, as.phylo:
library('TreeTools', quietly = TRUE, warn.conflicts = FALSE)
balanced7 <- BalancedTree(7)
pectinate7 <- PectinateTree(7)
RobinsonFoulds(balanced7, pectinate7)
RobinsonFoulds(balanced7, pectinate7, normalize = TRUE)
VisualizeMatching(RobinsonFouldsMatching, balanced7, pectinate7)

InfoRobinsonFoulds(balanced7, pectinate7)
VisualizeMatching(InfoRobinsonFoulds, balanced7, pectinate7)
}
\references{
\insertAllCited{}
}
\seealso{
Display paired splits: \code{\link[=VisualizeMatching]{VisualizeMatching()}}

Other tree distances: 
\code{\link{JaccardRobinsonFoulds}()},
\code{\link{KendallColijn}()},
\code{\link{MASTSize}()},
\code{\link{MatchingSplitDistance}()},
\code{\link{NNIDist}()},
\code{\link{NyeSimilarity}()},
\code{\link{PathDist}()},
\code{\link{SPRDist}()},
\code{\link{TreeDistance}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree distances}
