library("TreeTools", quietly = TRUE)

test_that("KC vector calculations", {
  
  bal7 <- ape::read.tree(text = "(((t1,t2),(t3,t4)),((t5,t6),t7));")
  expect_error(PathVector(bal7$edge), "must be of class\\b")
  bal7b <- ape::read.tree(text = "(((t5,t6),t7), ((t1,t2),(t3,t4)));")
  expect_equal(PathVector(UnrootTree(bal7)),
               PathVector(UnrootTree(RootTree(bal7, 1))))
  expect_equal(PathVector(UnrootTree(bal7)),
               PathVector(UnrootTree(RenumberTips(bal7b, bal7))))
  expect_equal(as.numeric(PathVector(RenumberTips(bal7b, bal7))),
               c(2, 4, 4, 6, 6, 5,
                    4, 4, 6, 6, 5,
                       2, 6, 6, 5,
                          6, 6, 5,
                             2, 3,
                                3))
  
  expect_equal(SplitVector(bal7), SplitVector(RootTree(bal7, 1)))
  expect_equal(SplitVector(bal7), SplitVector(bal7b))
  expect_equal(as.numeric(SplitVector(BalancedTree((9)))),
               c(2, 3, 5, 5, 7, 7, 7, 7,
                    3, 5, 5, 7, 7, 7, 7,
                       5, 5, 7, 7, 7, 7,
                          2, 6, 6, 6, 6,
                             6, 6, 6, 6,
                                2, 4, 4,
                                   4, 4,
                                      2))
})

test_that("KC distances with special vectors", {
  trees <- as.phylo(1:20, 12)
  expect_equal(PathDist(trees), KendallColijn(trees, Vector = PathVector),
               ignore_attr = TRUE)
})

test_that("KCDiameter() calculated", {
  Test <- function(nTip) {
    tips <- seq_len(nTip)
    expect_equal(KendallColijn(PectinateTree(tips), PectinateTree(rev(tips))),
                 KCDiameter(nTip))
  }
  Test(4)
  Test(40)
})
