% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel.R
\name{StartParallel}
\alias{StartParallel}
\alias{SetParallel}
\alias{GetParallel}
\alias{StopParallel}
\title{Calculate distances in parallel}
\usage{
StartParallel(...)

SetParallel(cl)

GetParallel(cl)

StopParallel()
}
\arguments{
\item{\dots}{Parameters to pass to \code{\link[=makeCluster]{makeCluster()}}.}

\item{cl}{An existing cluster.}
}
\value{
\code{StartParallel()} and \code{SetParallel()} return the previous value of
\code{options("TreeDist-cluster")}.

\code{GetParallel()} returns the currently specified cluster.

\code{StopParallel()} returns \code{TRUE} if a cluster was destroyed,
\code{FALSE} otherwise.
}
\description{
Accelerate distance calculation by employing multiple \acronym{CPU} workers.
}
\details{
"TreeDist" parallelizes the calculation of tree to tree distances via
the \code{\link[=parCapply]{parCapply()}} function, using a user-defined cluster specified in
\code{options("TreeDist-cluster")}.

\code{StartParallel()} calls \code{parallel::makeCluster()} and tells "TreeDist" to
use the created cluster.

\code{SetParallel()} tells "TreeDist" to use a pre-existing or user-specified
cluster.

\code{StopParallel()} stops the current TreeDist cluster.
}
\examples{
if (interactive()) { # Only run in terminal
  library("TreeTools", quietly = TRUE)
  nCores <- ceiling(detectCores() / 2)
  StartParallel(nCores) # Takes a few seconds to set up processes
  GetParallel()
  ClusteringInfoDistance(as.phylo(0:6, 100))
  StopParallel() # Returns system resources
}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
