% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPR.R
\name{.NonDuplicateRoot}
\alias{.NonDuplicateRoot}
\title{Non-duplicate root}
\usage{
.NonDuplicateRoot(parent, child, nEdge = length(parent))
}
\arguments{
\item{parent}{Integer vector corresponding to the first column of the edge
matrix of a tree of class \code{\link[ape]{phylo}}, i.e.
\code{tree[["edge"]][, 1]}}

\item{child}{Integer vector corresponding to the second column of the edge
matrix of a tree of class \code{\link[ape]{phylo}}, i.e.
\code{tree[["edge"]][, 2]}.}

\item{nEdge}{(optional) integer specifying the number of edges of a tree of
class \code{\link[ape]{phylo}}, i.e. \code{dim(tree$edge)[1]}}
}
\value{
\code{.NonDuplicateRoot()} returns a logical vector of length \code{nEdge},
specifying \code{TRUE} unless an edge identifies the same partition as
the root edge.
}
\description{
Identify, for each edge, whether it denotes a different partition from
the root edge.
The first edge of the input tree must be a root edge; this can be
accomplished using \code{Preorder()}.
}
\details{
This function is a copy of a deprecated ancestor in TreeTools; see
\href{https://github.com/ms609/TreeTools/issues/32}{#32}.
}
\examples{
tree <- TreeTools::Preorder(TreeTools::BalancedTree(8))
edge <- tree$edge
parent <- edge[, 1]
child <- edge[, 2]

which(!.NonDuplicateRoot(parent, child))
}
\author{
\href{https://smithlabdurham.github.io/}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\keyword{internal}
