% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TotalCopheneticIndex.R
\encoding{UTF-8}
\name{TotalCopheneticIndex}
\alias{TotalCopheneticIndex}
\alias{TCIContext}
\alias{TCIContext.numeric}
\title{Total Cophenetic Index}
\usage{
TotalCopheneticIndex(x)

TCIContext(x)

\method{TCIContext}{numeric}(x)
}
\arguments{
\item{x}{A tree of class \code{phylo}, its \verb{$edge} property, or a list thereof.}
}
\value{
\code{TotalCopheneticIndex()} returns an integer denoting the total cophenetic index.

\code{TCIContext()} returns a data frame detailing the maximum and minimum value
obtainable for the Total Cophenetic Index for rooted binary trees with the
number of leaves of the given tree, and the expected value under the Yule
and Uniform models.
The variance of the expected value is given under the Yule model, but cannot
be obtained by calculation for the Uniform model.
}
\description{
\code{TotalCopheneticIndex()} calculates the total cophenetic index
\insertCite{Mir2013}{TreeTools} for any tree, a measure of its balance;
\code{TCIContext()} lists its possible values.
}
\details{
The Total Cophenetic Index is a measure of tree balance -- i.e. whether
a (phylogenetic) tree comprises symmetric pairs of nodes, or has a pectinate
"caterpillar" shape.
The index has a greater resolution power than Sackin's and Colless' indices,
and can be applied to trees that are not perfectly resolved.

For a tree with \emph{n} leaves, the Total Cophenetic Index can take values of
0 to \code{choose(n, 3)}.
The minimum value is higher for a perfectly resolved (i.e. dichotomous) tree
(see Lemma 14 of Mir \emph{et al.} 2013).
Formulae to calculate the expected values under the Yule and Uniform models
of evolution are given in Theorems 17 and 23.

Full details are provided by \insertCite{Mir2013;textual}{TreeTools}.
}
\examples{
# Balanced trees have the minimum index for a binary tree;
# Pectinate trees the maximum:
TCIContext(8)
TotalCopheneticIndex(PectinateTree(8))
TotalCopheneticIndex(BalancedTree(8))
TotalCopheneticIndex(StarTree(8))


# Examples from Mir et al. (2013):
tree12 <- ape::read.tree(text="(1, (2, (3, (4, 5))));")  #Fig. 4, tree 12
TotalCopheneticIndex(tree12) # 10
tree8  <- ape::read.tree(text="((1, 2, 3, 4), 5);")      #Fig. 4, tree 8
TotalCopheneticIndex(tree8)  # 6
TCIContext(tree8)
TCIContext(5L) # Context for a tree with 5 leaves.

}
\references{
\insertAllCited{}
}
\seealso{
\code{cophen.index()} in the package
\href{https://github.com/LuciaRotger/CollessLike}{\pkg{CollessLike}}
provides an alternative implementation of this index and its predecessors.

Other tree characterization functions: 
\code{\link{CladisticInfo}()},
\code{\link{Consensus}()},
\code{\link{Stemwardness}}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree characterization functions}
