% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_2rm.R
\name{smooth_2rm}
\alias{smooth_2rm}
\title{Smooth two-regression estimates over specified periods}
\usage{
smooth_2rm(AG, time_var = "Timestamp", unit = "60 sec", verbose = FALSE, ...)
}
\arguments{
\item{AG}{data frame of ActiGraph data}

\item{time_var}{character scalar. Name of the timestamp variable (required to
verify that input epoch length is 10 seconds)}

\item{unit}{the interval to use for smoothing (see
\code{\link[lubridate]{floor_date}}). Default is \code{"60 sec"}}

\item{verbose}{logical. Print updates to console?}

\item{...}{currently unused}
}
\value{
Smoothed data, collapsed in the specified intervals
}
\description{
Smooth two-regression estimates over specified periods
}
\examples{

data(all_data, package = "TwoRegression")

  result <- TwoRegression(
    all_data, "Hibbing 2018", gyro_var = "Gyroscope_VM_DegPerS",
    direction_var = "mean_magnetometer_direction",
    site = c("Left Ankle", "Right Ankle"), algorithm = 1:2
  )

  smooth_2rm(result)

}
