% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_clustering.R
\name{correlation_clustering}
\alias{correlation_clustering}
\title{Hierarchical Correlation Clustering}
\usage{
correlation_clustering(
  data,
  target = NULL,
  weight = c(),
  distance_method = "euclidean",
  normalize = TRUE,
  labels = NULL,
  learn = FALSE,
  waiting = FALSE
)
}
\arguments{
\item{data}{A data frame containing the main data}

\item{target}{A data frame, numeric vector or matrix to use as correlation target. Default is NULL.}

\item{weight}{A numeric vector of weights. Default is empty vector.}

\item{distance_method}{A string specifying the distance metric to use. Options are:
\itemize{
\item "euclidean" - Euclidean distance
\item "manhattan" - Manhattan distance
\item "canberra" - Canberra distance
\item "chebyshev" - Chebyshev distance
}}

\item{normalize}{A boolean parameter indicating whether to normalize weights. Default is TRUE.}

\item{labels}{A string vector for graphical solution labeling. Default is NULL.}

\item{learn}{A boolean indicating whether to show detailed algorithm explanations. Default is FALSE.}

\item{waiting}{A boolean controlling pauses between explanations. Default is TRUE.}
}
\value{
An R object containing:
\itemize{
\item dendrogram - A hierarchical clustering dendrogram
\item sortedValues - A data frame with the sorted cluster values
\item distances - A data frame with the sorted distances
}
}
\description{
Performs hierarchical correlation clustering by applying weights, distance metrics, and other parameters
to analyze relationships between data points and a target.
}
\details{
This function executes the complete hierarchical correlation method in the following steps:
\enumerate{
\item The function transforms data into useful objects
\item Creates the clusters
\item Calculates the distance from the target to every cluster using the specified distance metric
\item Orders the distances in ascending order
\item Orders the clusters according to their distance from the previous step
\item Shows the sorted clusters and the distances used
}
}
\examples{
data <- matrix(c(1,2,1,4,5,1,8,2,9,6,3,5,8,5,4), ncol=3)
dataFrame <- data.frame(data)
target1 <- c(1,2,3)
target2 <- dataFrame[1,]
weight1 <- c(1,6,3)
weight2 <- c(0.1,0.6,0.3)

# Basic usage
correlation_clustering(dataFrame, target1)

# With weights
correlation_clustering(dataFrame, target1, weight1)

# Without weight normalization
correlation_clustering(dataFrame, target1, weight1, normalize = FALSE)

# Using Canberra distance with weights
correlation_clustering(dataFrame, target1, weight2, distance = "canberra", normalize = FALSE)

# With detailed explanations
correlation_clustering(dataFrame, target1, learn = TRUE)

}
\author{
Original authors:
\itemize{
\item Roberto Alcantara \email{roberto.alcantara@edu.uah.es}
\item Juan Jose Cuadrado \email{jjcg@uah.es}
\item Universidad de Alcala de Henares
}
}
