% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify.R
\name{downloadTCGA}
\alias{downloadTCGA}
\title{Easily Download TCGA Data by Several Options}
\usage{
downloadTCGA(project = NULL, data_type = NULL, file_type = NULL,
  destdir = tempdir(), force = FALSE, ...)
}
\arguments{
\item{project}{default is \code{NULL}. Should be one or more of TCGA project id (character vector) provided by Xena.
See all available project id, please use \code{availTCGA("ProjectID")}.}

\item{data_type}{default is \code{NULL}. Should be a character vector specify data type.
See all available data types by \code{availTCGA("DataType")}.}

\item{file_type}{default is \code{NULL}. Should be a character vector specify file type.
See all available file types by \code{availTCGA("FileType")}.}

\item{destdir}{specify a location to store download data. Default is system temp directory.}

\item{force}{logical. if \code{TRUE}, force to download data no matter whether files exist.
Default is \code{FALSE}.}

\item{...}{other argument to \code{download.file} function}
}
\value{
same as \code{XenaDownload()} function result.
}
\description{
TCGA is a very useful database and here we provide this function to
download TCGA (include TCGA Pancan) datasets in human-friendly way. User who are not
familiar with R operation will benefit from this.
}
\details{
All availble information about datasets of TCGA can access vis \code{availTCGA()} and
check with \code{showTCGA()}.
}
\examples{
\donttest{
# download RNASeq data (use UVM as example)
downloadTCGA(project = "UVM",
                 data_type = "Gene Expression RNASeq",
                 file_type = "IlluminaHiSeq RNASeqV2")
}
}
\seealso{
\code{\link[UCSCXenaTools]{XenaQuery}},
\code{\link[UCSCXenaTools]{XenaFilter}},
\code{\link[UCSCXenaTools]{XenaDownload}},
\code{\link[UCSCXenaTools]{XenaPrepare}},
\code{\link[UCSCXenaTools]{availTCGA}},
\code{\link[UCSCXenaTools]{showTCGA}}
}
\author{
Shixiang Wang <w_shixiang@163.com>
}
